.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DfSetJust 3D  "Dore"
.SH NAME
DfSetJust \- Set the frame justification
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DfSetJust(frame, left, bottom)
DtObject frame;
DtReal left, bottom;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DFSJ(FRAME, LEFT, BOTTOM)
INTEGER*4 FRAME
REAL*8 LEFT, BOTTOM 
.in -.5i
.fi
.SH DESCRIPTION
.IX DFSJ
.IX DfSetJust
.I DfSetJust
sets the justification of a specified frame, \f2frame\fP.  When the
aspect ratios of the frame border and the device viewport are not
the same, there will be extra "white space" inside the device viewport.
The frame justification provides a mechanism for controlling where this
white space is positioned.
.PP
The \f2left\fP parameter defines a value between 0.0 and 1.0
inclusive specifying the fraction of the white space to be inserted 
between the bottom left hand corner of the viewport and the left of the
displayed image.  Similarly, the \f2bottom\fP parameter specifies the
fraction of white space to be inserted between the bottom left hand
corner of the viewport and the bottom of the displayed image.
.SH ERRORS
.I DfSetJust
will fail if the frame handle is invalid.
.TP 15
[WARNING - invalid frame handle]
.PP
\f2DfSetJust\fP will fail if the \f2left\fP or \f2bottom\fP
parameters are out of range.
.TP 15
[WARNING - value out of range]
.SH DEFAULTS
The default is \f2left\fP = 0.5 and \f2bottom\fP = 0.5 creating
an even distribution of white space in both directions.
.SH "SEE ALSO"
.na
.nh
DdSetFrame(3D), DfInqBoundary(3D), DfInqJust(3D), DfUpdate(3D)
.ad
.h
