.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgCheck 3D  "Dore"
.SH NAME
DgCheck \- Check for circularities within a group network
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtGroupNetworkStatus DgCheck(group)
DtObject group;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DGCK(GROUP)
INTEGER*4 GROUP
.in -.5i
.fi
.SH DESCRIPTION
.IX DGCK
.IX DgCheck
.I DgCheck
finds out if there are any circularities within the
group network referenced by the root node, \f2group\fP.  Many
execution methods (i.e., for rendering and picking) do not check
for the existence of circularity within the group networks they
execute and will develop fatal errors if such circularities are
allowed to persist.  It is the user's responsibility never to
use circular group networks in Dor\o.\(aae..
.PP
The return value will be one of the following:
.IP "\f2DcGroupOk\fP <\f2DCGOK\fP>"
The group is free of circularities.
.IP "\f2DcGroupBad\fP <\f2DCGBAD\fP>"
The group has a non-recoverable circularity.
.SH ERRORS
.I DgCheck
will fail if the group handle is invalid.
.TP 15
[WARNING - invalid group handle]
.PP
.I DgCheck
will fail if an update is in progress.
.TP 15
[WARNING - traversal in progress]
.SH "SEE ALSO"
DgOpen(3D), DoGroup(3D), DoInLineGroup(3D)
