.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgInqElePtr 3D  "Dore"
.SH NAME
DgInqElePtr \- Return the location of the group element pointer of the current group
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtInt DgInqElePtr()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DGQEP()
.in -.5i
.fi
.SH DESCRIPTION
.IX DGQEP
.IX DgInqElePtr
.I DgInqElePtr
returns the current location of the group element pointer of the
currently open group.
.PP
Each group has an element pointer that identifies the current
editing position within the group.  The element pointer points between
elements of a group.   A value of 0 indicates that the element pointer
is pointing before the first element in the group, and a value of \f2n\fP
(where \f2n\fP is the current size of the group) indicates that the element
pointer is pointing after the last element in the group.
.SH ERRORS
.I DgInqElePtr
will fail if no group is currently open; the value -1 is returned.
.TP 15
[WARNING - a group is not currently open]
.SH "SEE ALSO"
DgSetElePtr(3D), DgSetElePtrRelLabel(3D)
