.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgOpen 3D  "Dore"
.SH NAME
DgOpen \- Open a group object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DgOpen(group, append)
DtObject group;
DtFlag append;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DGO(GROUP, APPEND)
INTEGER*4 GROUP
INTEGER*4 APPEND
.in -.5i
.fi
.SH DESCRIPTION
.IX DGO
.IX DgOpen
.I DgOpen
opens the group object, \f2group\fP.  
Open groups can be nested in Dore, but there can be only one active
group at any given time.  The active group is the most recently opened
group.  It is affected by any implicit
\f2DgXXXX\fP commands, such as \f2DgReplaceObj\fP <\f2DGRO\fP>
and \f2DgAddObj\fP <\f2DGAO\fP>.
.PP
If the append flag, \f2append\fP, is \f2DcFalse\fP <\f2DCFALS\fP>,
the group's element pointer
is left as it was before the group was opened.  If the append flag is 
\f2DcTrue\fP <\f2DCTRUE\fP>, the group element pointer is placed
at the end of the
group so that new elements are appended to the open group.
.SH ERRORS
.I DgOpen
will fail if the group handle is invalid.
.TP 15
[WARNING - invalid group handle]
.SH "SEE ALSO"
DgInqOpen(3D), DoGroup(3D), DoInLineGroup(3D)
