.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoAmbientSwitch 3D  "Dore"
.SH NAME
DoAmbientSwitch \- Create a primitive attribute object for enabling or disabling use of the ambient component of a surface's response to light
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoAmbientSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOAMBS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOAMBS
.IX DoAmbientSwitch
\f2DoAmbientSwitch\fP creates an ambient switch primitive attribute
object.  The parameter \f2switch\fP specifies whether or
not the surfaces of subsequently executed primitive objects have an
ambient component contribution.
.PP
The ambient component of an object's surface shade will be computed using
the diffuse color (see \f2DoDiffuseColor\fP)
and the ambient intensity (see \f2DoAmbientIntens\fP)
attributes to determine the response of the surface to ambient light.
.PP
If the ambient switch attribute of an object is \f2DcOff\fP
<\f2DCOFF\fP>,
that object will render itself without an ambient shading component
regardless of the settings of the diffuse color and ambient intensity
attributes.  
.SH DEFAULTS
The default value for \f2DoAmbientSwitch\fP is \f2DcOn\fP <\f2DCON\fP>.
.SH "SEE ALSO"
DoDiffuseColor(3D), DoAmbientIntens(3D)
