.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoBackfaceCullSwitch 3D  "Dore"
.SH NAME
DoBackfaceCullSwitch \- Create a primitive attribute object for enabling or disabling backface culling
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoBackfaceCullSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOBFCS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOBFCS
.IX DoBackfaceCullSwitch
.I DoBackfaceCullSwitch
creates a backface cull switch primitive attribute object.
The parameter \f2switchvalue\fP specifies whether 
subsequent primitive objects
will ignore their backward facing surfaces
(i.e., those facing away from the viewer) as an efficiency measure when
rendering themselves.  
The possible values for \f2switchvalue\fP are:
.IP "\f2DcOn\fP <\f2DCON\fP>"
Backward facing surfaces will be ignored.
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
Backward facing surfaces will not be ignored.
.PP
For a primitive object to be backface culled,
it must be backface cullable and the backface cull switch
must be enabled.
In general, backface culling should be enabled for any collection
of primitive objects consisting of closed surfaces.
The technique used to determine whether a
surface is backward facing depends on the renderer
and/or device.
.SH DEFAULTS
The default value for \f2DoBackfaceCullSwitch\fP is
\f2DcOn\fP <\f2DCON\fP>.
.SH "SEE ALSO"
DoBackfaceCullable(3D), DoHiddenSurfSwitch(3D)
