.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoCameraMatrix 3D  "Dore"
.SH NAME
DoCameraMatrix \- Create a camera matrix studio attribute object.
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoCameraMatrix(matrix)
DtMatrix4x4 matrix;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOCMX(MATRIX)
REAL*8 MATRIX(4,4)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOCMX
.IX DoCameraMatrix
.I DoCameraMatrix
creates a camera matrix studio attribute object.
When \f2DoCameraMatrix\fP is executed in a definition group,
its parameter \f2matrix\fP replaces
the camera projection matrix used for all subsequently
executed camera objects.
.PP
The argument \f2matrix\fP is an arbitrary 4x4 matrix; singular matrices will
cause fatal errors.  \f2DoCameraMatrix\fP is intended for
advanced users needing special effects.  Most useful camera matrices are 
obtainable using by \f2DoProjection\fP <\f2DOPRJ\fP>, \f2DoParallel\fP
<\f2DOPAR\fP>, or \f2DoPerspective\fP <\f2DOPER\fP>.
.SH ERRORS
.I DoCameraMatrix
will fail if the matrix is singular.
.TP 15
[WARNING - non-invertible matrix]
.SH "SEE ALSO"
DoParallel(3D), DoPerspective(3D), DoProjection(3D)
