.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoGlbRendRayLevel 3D "Dore"
.SH NAME
DoGlbRendRayLevel \- Create a ray level studio attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoGlbRendRayLevel(raylevel)
DtInt raylevel;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOGRRL(RAYLEV)
INTEGER*4 RAYLEV
.in -.5i
.fi
.SH DESCRIPTION
.IX DOGRRL
.IX DoGlbRendRayLevel
\f2DoGlbRendRayLevel\fP creates a ray level studio attribute object.
The parameter \f2raylevel\fP
specifies the maximum number of times a ray will be allowed to bounce
from primitive objects during ray tracing.
Ray tracing is the process of determining which objects in the scene
are in the path of an arbitrary vector (ray) in space.  Ray tracing
is used in the generation of global shading effects
like shadows, object-to-object reflections, and transparency.
.PP
\f2DoGlbRendRayLevel\fP affects only renderers that use
ray casting.  The rendering style is set with \f2DvSetRendStyle\fP
<\f2DVSRS\fP>.
.SH DEFAULTS
The default value for \f2DoGlbRendRayLevel\fP is 3.
.SH "SEE ALSO"
.na
.nh
DoGlbRendMaxObjs(3D), DoGlbRendMaxSub(3D), DvSetRendStyle(3D)
.ad
.hy
