.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoIntermediateDispType 3D  "Dore"
.SH NAME
DoIntermediateDispType \- Create an intermediate display type studio attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoIntermediateDispType(type,parms)
DtIntermediateDispType type;
DtInt parms[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOINDT(TYPE,PARMS)
INTEGER*4 TYPE
INTEGER*4 PARMS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOINDT
.IX DoIntermediateDispType
.I DoIntermediateDispType
creates an intermediate display type studio attribute object.
\f2DoIntermediateDispType\fP is used with rendering techniques that generate 
multiple images when a single update function is called. 
For example, with progressive radiosity rendering,
images are computed until a convergence criterion is met.
\f2DoIntermediateDispType\fP indicates which of these intermediate
images should be displayed, if any. The final image is always displayed.
.PP
The argument \f2type\fP can be one of the following:
.IP "\f2DcDispIntermediateAll\fP <\f2DCDIA\fP>"
All intermediate images are displayed. \f2parms\fP should be \f2DcNullPtr
<DCNULL>\fP.
.IP "\f2DcDispFinal\fP <\f2DCDFIN\fP>"
Only the final image is displayed. \f2parms\fP should be \f2DcNullPtr
<DCNULL>\fP.
.IP "\f2DcDispRegularIntervals\fP <\f2DCDRGI\fP>"
Intermediate images are displayed every \f2parms[0]\fP images.
.IP "\f2DcDispIrregularIntervals\fP <\f2DCDIGI\fP>"
Only specific intermediate images are displayed.
\f2parms[0]\fP is the total number
of intermediate images to be displayed.
\f2parms[i]\fP is an integer indicating that
the \f2i\fPth intermediate image should be displayed.
.PP
With radiosity, the first imtermediate frame number is 0 (zero).
In this initial scene, only the emissive objects have a
non-zero intensity; other radiosity objects will appear black.
.SH DEFAULTS
The default values for \f2DoIntermediateDispType\fP are \f2DcDispIntermediateAll\fP
<\f2DCDIA\fP> with \%\f2parms\fP equals to \f2DcNullPtr <DCNULL>\fP.
.SH "SEE ALSO"
.na
.nh
DoRadiositySwitch(3D),
DvSetRadiosityConvergence(3D),
DvSetRadiosityUpdateType(3D)
.ad
.hy
