.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLight 3D  "Dore"
.SH NAME
DoLight \- Create a light studio object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLight()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOLT()
.in -.5i
.fi
.SH DESCRIPTION
.IX DOLT
.IX DoLight
\f2DoLight\fP creates a light object.  A light is a studio object.  It obtains
properties only through attribute inheritance and then only during execution of
definition objects.
Lights obtain their position and orientation through inheritance of the
current transformation matrix attribute.  
.PP
All lights have intensity and color and are of a specific type.
The intensity and color are
determined by \f2DoLightIntens\fP <\f2DOLI\fP> and \f2DoLightColor\fP
<\f2DOLC\fP>.
The light type is determined by \f2DoLightType\fP <\f2DOLNT\fP>.
Depending on the type, some lights also have one or more of the following:
position, direction, attenuation, spread angles, and spread exponent.
.PP
Light objects are not visible; only their effects are.  One
may have an arbitrary number of lights per view.  Lights can be turned on
and off per primitive object in the scene (see \f2DoLightSwitch\fP).
.SH DEFAULTS
The default light model is an infinite light source of intensity 1.0
located at the origin and pointing down the Z-axis in the negative
direction.
.SH "SEE ALSO"
.na
.nh
DoLightColor(3D), DoLightIntens(3D), DoLightSwitch(3D), DoLightType(3D)
.ad
.hy
