.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLightIntens 3D  "Dore"
.SH NAME
DoLightIntens \- Create a light intensity studio attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLightIntens(intensity)
DtReal intensity;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOLI(INTENS)
REAL*8 INTENS
.in -.5i
.fi
.SH DESCRIPTION
.IX DOLI
.IX DoLightIntens
.I DoLightIntens
creates a light intensity studio attribute object.
The parameter \f2intensity\fP specifies the overall intensity
of subsequent light objects.  It may be any non-negative real number; however,
normal light intensities range between 0.0 and 1.0.
.SH ERRORS
.I DoLightIntens
issue a warning if \f2intensity\fP is negative; the intensity will be set
to 0.0.
.TP 15
[WARNING - negative light intensity]
.SH DEFAULTS
The default \f2DoLightIntens\fP is 1.0.
.SH "SEE ALSO"
DoLight(3D), DoLightColor(3D)
