.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLocalAntiAliasStyle 3D "Dore"
.SH NAME
DoLocalAntiAliasStyle \- Create a primitive attribute object for setting the style of local antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLocalAntiAliasStyle(style)
DtLocalAntiAliasStyle style;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOLAST(STYLE)
INTEGER*4 STYLE
.in  -.5i
.fi 
.IX "DoLocalAntiAliasStyle"
.IX "DOLAST"
.SH DESCRIPTION
.LP
\f2DoLocalAntiAliasStyle\fP creates a primitive attribute object for
setting the style of local antialiasing.
Local antialiasing removes sampling-induced artifacts on an
object basis.
.PP
The parameter \f2style\fP specifies the style of 
local antialiasing to be done.
The possible values of \f2style\fP are:
.IX "DcLocalAntiAliasFast"
.IX "DCLAAF"
.IP "\f2DcLocalAntiAliasFast\fP <\f2DCLAAF\fP>"
The fastest available method of antialiasing.
.IX "DcLocalAntiAliasIntermediate"
.IX "DCLAAI"
.IP "\f2DcLocalAntiAliasIntermediate\fP <\f2DCLAAI\fP>"
An intermediate form of antialiasing.
.IX "DcLocalAntiAliasBest"
.IX "DCLAAB"
.IP "\f2DcLocalAntiAliasBest\fP <\f2DCLAAB\fP>"
The primitive should be antialiased using the method that produces the
best results, even if it is the slowest method.
.LP
Local antialiasing will not be performed unless the 
\f2DoLocalAntiAliasSwitch\fP 
.nh
<\f2DOLASW\fP> 
.hy
is enabled.
.SH DEFAULTS
The default value for \f2DoLocalAntiAliasStyle\fP is
\f2DcLocalAntiAliasIntermediate\fP.
.SH SEE ALSO
.na
DoLocalAntiAliasSwitch(3D)
.ad
\&
