.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLocalAntiAliasSwitch 3D "Dore"
.SH NAME
DoLocalAntiAliasSwitch \- Create a primitive attribute object for enabling or disabling local antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLocalAntiAliasSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOLASW(SWVAL)
INTEGER*4 SWVAL
.in  -.5i
.fi 
.IX "DoLocalAntiAliasSwitch"
.IX "DOLASW"
.SH DESCRIPTION
.LP
\f2DoLocalAntiAliasSwitch\fP creates an antialiasing switch primitive 
attribute object for local antialiasing.
.LP
The parameter \f2switchvalue\fP specifies whether subsequent primitives
are rendered using local antialiasing.
The values that can be returned for \f2switchvalue\fP are:
.IX DcOn
.IX DCON
.IP "\f2DcOn\fP <\f2DCON\fP>"
Local antialiasing is enabled.
If more than one style of local antialiasing is supported the
\f2DoLocalAntiAliasStyle\fP <\f2DOLAST\fP> attribute is used
to specify the style.
.IX DcOff
.IX DCOFF
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
Local antialiasing is disabled.
.LP
Note that local antialiasing is independent of the image antialiasing
specified by the \f2DoSample...\fP camera attributes.
.SH DEFAULTS
The default \f2DoLocalAntiAliasSwitch\fP is \f2DcOff\fP.
.SH SEE ALSO
.na
DoLocalAntiAliasStyle(3D),
DoSampleAdaptiveSwitch(3D),
DoSampleJitterSwitch(3D),
DoSampleSuperSwitch(3D)
.ad
\&
