.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoNURBSurf 3D  "Dore"
.SH NAME
DoNURBSurf \- Create a non-uniform rational B-Spline surface primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoNURBSurf(colormodel, ctrlpointtype, uv_area, 
	order_u, n_knot_u, knot_u, order_v, n_knot_v, 
	knot_v, n_ctrl_u, n_ctrl_v, ctrl_vertices)
DtColorModel colormodel;
DtCtrlPointType ctrlpointtype;
DtNArea uv_area;
DtInt order_u, order_v;
DtInt n_knot_u, n_knot_v;
DtReal knot_u[\|], knot_v[\|];
DtInt n_ctrl_u, n_ctrl_v;
DtReal ctrl_vertices[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DONRBS(COLMOD, CPTTYP, UVAREA, 
	ORDERU, NKNOTU, KNOTU, ORDERV, 
	NKNOTV, KNOTV, NCTRLU, NCTRLV, 
	CTLVTX)
INTEGER*4 COLMOD
INTEGER*4 CPTTYP
REAL*8 UVAREA(4)
INTEGER*4 ORDERU, ORDERV
INTEGER*4 NKNOTU, NKNOTV
REAL*8 KNOTU(NKNOTU), KNOTV(NKNOTV)
INTEGER*4 NCTRLU, NCTRLV
REAL*8 CTLVTX(4, NCTRLV, NCTRLU)
.in -.5i
.fi
.SH DESCRIPTION
.IX DONRBS
.IX DoNURBSurf
.I DoNURBSurf
defines a non-uniform rational B-Spline surface primitive object.
.PP
The parameter \f2colormodel\fP specifies the color model used if the 
control points contain color information for shading purposes.
The parameter \f2ctrlpointtype\fP, which specifies the
nature of the control points, can have only one value,
which specifies the nature of the control point, \f2DcCtr\fP.
.PP
The parameter \f2uv_area\fP consists of two pairs of 
real numbers that
define the parametric intervals used by the NURBS surface.  The parameters 
\f2n_knot_u\fP and \f2n_knot_v\fP specify the
number of values in the lists \f2knot_u\fP and \f2knot_v\fP.
The parameters \f2order_u\fP and \f2order_v\fP express
the overall order of the NURBS along \f2u\fP and \f2v\fP.  
The parameters \f2n_ctrl_u\fP
and \f2n_ctrl_v\fP specify the layout of vertices as a grid.
The vertices themselves (\f2ctrl_vertices\fP) are contained in a one-dimensional
array of four dimensional control points.  They are ordered
in the array the same as if they were being read as
sequential values from a two-dimensional array
of \f2u\fP and \f2v\fP with \f2v\fP varying fastest.
FORTRAN array
element FOO(j+1,i+1).
.PP
If this primitive object defines a closed surface or will be oriented with
backfacing parts of the surface away from the viewer, then backface culling
may speed up the rendering time.  See \f2DoBackfaceCullable\fP and
\f2DoBackfaceCullSwitch\fP.
.SH ERRORS
\f2n_knot_u\fP must equal the sum of \f2order_u\fP and \f2n_ctrl_u\fP, and
\f2n_knot_v\fP must equal the sum of \f2order_v\fP and \f2n_ctrl_v\fP.
.TP 15
[WARNING - value out of range]
.PP
.I DoNURBSurf
will fail if \f2order_u\fP and \f2order_v\fP are not between 0 and 25,
inclusive.
.TP 15
[SEVERE - bad curve order]
.SH "SEE ALSO"
DoBackfaceCullSwitch(3D), DoBackfaceCullable(3D), DoPatch(3D), DoRepType(3D),
DoSubDivSpec(3D), DoInterpType(3D)
