.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoParallel 3D  "Dore"
.SH NAME
DoParallel \- Create a parallel studio attribute object for cameras
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoParallel(window_size, hither, yon)
DtReal window_size, hither, yon;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPAR(WWSIZE, HITHER, YON)
REAL*8 WWSIZE, HITHER, YON
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPAR
.IX DoParallel
.I DoParallel
creates a parallel studio attribute object for cameras. 
The parameter \f2window_size\fP specifies the square size of the field
of view that is centered at the origin and parallel to the XY-plane.
The parameters \f2hither\fP and \f2yon\fP specify the location
of the front and back clipping planes in camera coordinates.  
Because the camera's location in its own relative coordinate system is
always at (0.0, 0.0, 0.0) looking down the negative Z
axis, both \f2hither\fP and \f2yon\fP will typically be negative.
.SH ERRORS
.I DoParallel
will fail if \f2hither\fP is less than or equal to \f2yon\fP.
.TP 15
[WARNING - value out of range]
.SH "SEE ALSO"
.na
.nh
DoCamera(3D), DoCameraMatrix(3D), DoPerspective(3D), DoProjection(3D)
.ad
.hy
