.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPointList 3D "Dore"
.SH NAME
DoPointList \- Create a point list primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPointList(colormodel, vertextype, pointcount, 
	vertices)
DtColorModel colormodel;
DtVertexType vertextype;
DtInt pointcount;
DtReal vertices[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPNTL(COLMOD, VTXTYP, PNTCNT, 
	VTXS)
INTEGER*4 COLMOD
INTEGER*4 VTXTYP
INTEGER*4 PNTCNT
REAL*8 VTXS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPNTL
.IX DoPointList
.I DoPointList
creates a primitive object that defines a list of independent points.
The parameter \f2colormodel\fP specifies the color model to be used when
defining vertex colors (if any).
The parameter \f2vertextype\fP specifies the exact nature of the vertex:
whether the vertex contains color, normal, or
\f2uv/uvw\fP information for shading and
texture mapping.
for more information, refer to Chapter 6, \f2Dore Vertex Types\fP,
in the \f2Dore Reference Manual\fP or 
to the \f2VertexTypes\fP on-line manual page.)
The parameter \f2pointcount\fP contains the number of points in the list.
The parameter \f2vertices\fP is an array containing data for
\f2pointcount\fP vertices.
.PP
If vertex normals are not provided, backface culling has no effect
for points because they have no surface
on which to define a geometric normal.
.SH "SEE ALSO"
DoLineList(3D), VertexTypes(3D)
\&
