.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPolyline 3D  "Dore"
.SH NAME
DoPolyline  \- Create a connected line segment primitive object
.BP
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPolyline(colormodel, vertextype, vertexcount, 
	vertices)
DtColorModel colormodel;
DtVertexType vertextype;
DtInt vertexcount;
DtReal vertices[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPL(COLMOD, VTXTYP, VTXCNT, 
	VTXS)
INTEGER*4 COLMOD
INTEGER*4 VTXTYP
INTEGER*4 VTXCNT
REAL*8 VTXS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPL
.IX DoPolyline
.I DoPolyline
creates a primitive object that defines a collection of vertices
connected into a continuous set of line segments.
.PP
The parameter \f2colormodel\fP specifies the color model used if the vertices
contain color information for shading purposes.
The parameter \f2vertextype\fP specifies the exact nature of the vertices.
for more information, refer to Chapter 6, \f2\Dore Vertex Types\fP,
in the \f2\Dore Reference Manual\fP or to the \f2VertexTypes\fP 
on-line manual page.)
.PP
The parameter \f2vertexcount\fP contains the number of vertices; there must be
at least two.  The parameter \f2vertices\fP is an array of
vertices.  Vertices are listed in the order in which they connect.
Polylines may be circular, interconnected, or may reconnect the same pair of
vertices multiple times.
.SH ERRORS
\f2DoPolyline\fP will error if \f2vertexcount\fP is less than two.
.TP 15
[WARNING - invalid parameter]
.SH "SEE ALSO"
.na
.nh
DoLineList(3D), DoLineWidth(3D),
DoLineType(3D), VertexTypes(3D)
.ad
.hy
