.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoProjection 3D  "Dore"
.SH NAME
DoProjection \- Create a projection studio attribute object for cameras
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoProjection(window, ptype, prp, viewplane, 
	hither, yon)
DtArea *window;
DtProjectionType ptype;
DtPoint3 prp;
DtReal viewplane;
DtReal hither;
DtReal yon;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPRJ(WINDOW, PTYPE, PRP, VWPLAN, 
	HITHER, YON)
REAL*8 WINDOW(4)
INTEGER*4 PTYPE
REAL*8 PRP(3)
REAL*8 VWPLAN
REAL*8 HITHER
REAL*8 YON
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPRJ
.IX DoProjection
.I DoProjection
creates a projection studio attribute object for cameras.
The parameters \f2hither\fP and \f2yon\fP specify the location of the
near and far clipping planes relative to the camera.  
The hither plane,
yon plane, and viewing plane are defined perpendicular to the
direction of view and should be specified in camera coordinates.
Because the camera's location (in its own relative coordinate system) is
always (0.0, 0.0, 0.0) looking down the negative Z-axis,
both the hither plane and the yon plane must be ahead of the camera,
that is, the parameters \f2hither\fP and \f2yon\fP must be negative.
.PP
The parameter \f2viewplane\fP should also be negative. Its absolute
value indicates the distance from the camera to the
viewing plane.
The parameter \f2window\fP specifies an arbitrary rectangular
region on the viewing plane, also in camera coordinates.
.PP
The parameter \f2prp\fP (projection reference point) specifies a
point relative to the camera.  If
the parameter \f2ptype\fP is \f2DcPerspective\fP <\f2DCPRSP\fP>,
\f2prp\fP and the
window corners specify a pyramid.  The region of the pyramid between
the near and far clipping planes defines the view volume.  If
\f2ptype\fP is \f2DcParallel\fP <\f2DCPRLL\fP>, the view volume is the
parallelepiped produced by the parallel projection of the window corners
between the near and far clipping planes along the line from the
\f2prp\fP through the center of the window.
For perspective transformations, the Z component of the \f2prp\fP must be
greater than \f2viewplane\fP (or smaller, if absolute values are considered).
.SH ERRORS
.I DoProjection
will fail if \f2hither\fP is less than or equal to \f2yon\fP.
.TP 15
[WARNING - value out of range]
.BP
\ \ 
.PP
.I DoProjection
will fail if \f2hither\fP is greater than or equal to 0.0.
.TP 15
[WARNING - value out of range]
.SH "SEE ALSO"
.na
.nh
DoCamera(3D), DoCameraMatrix(3D), DoParallel(3D), DoPerspective(3D)
.ad
.hy
