.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoRadiositySwitch 3D  "Dore"
.SH NAME
DoRadiositySwitch \- Create radiosity switch primitive attribute object 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoRadiositySwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DORADS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DORADS
.IX DoRadiositySwitch
\f2DoRadiositySwitch\fP creates a radiosity switch primitive attribute
object.  The parameter
\f2switchvalue\fP specifies whether radiosity calculations
and display should apply to subsequently executed primitive objects.
.PP
If the radiosity switch is \f2DcOn\fP <\f2DCON\fP>,
the radiosity update type set by \f2DvSetRadiosityUpdateType <DVSRDU>\fP determines
if calculations should be performed, ignored, or if results from previous
radiosity
calculations should be used for display.
For the primitive objects rendered using radiosity, 
the \f2DoSurfaceShade <DOSRFS>\fP and \f2DoInterpType <DOIT>\fP
attributes, and
the light source objects of the studio group are ignored.
Lights are defined as emissive primitive objects,
using the emission attributes (\f2DoEmission-\fP functions).
If \f2DoRadiosityAmbientSwitch <DORDAS>\fP is on, 
an ambient component will be estimated during the
radiosity solution and its contribution will be added
to primitive surfaces at display time.
.PP
If the radiosity switch attribute is \f2DcOff\fP
<\f2DCOFF\fP>, radiosity is ignored for the subsequent primitive objects
and shading
is performed according to the shading model selected with \f2DoSurfaceShade
<DOSRFS>\fP and and \f2DoInterpType <DOIT>\fP.
.sp
For the radiosity switch to have any effect,
radiosity must first be initialized with a call to
\f2DsRadiosityInitialize <DSRDIN>\fP.
.SH DEFAULTS
The default value for \f2DoRadiositySwitch\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH "SEE ALSO"
.nh
.na
DsRadiosityInitialize(3D),
DvSetRadiosityUpdateType(3D),
DvSetFormFactorCompType(3D),
DvSetRadiosityConvergence(3D)
DoEmissionSwitch(3D),
DoEmissionColor(3D),
DoEmissionFactor(3D),
DoRadiosityAmbientSwitch(3D)
.ad
.hy
