.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoRefractionSwitch 3D "Dore"
.SH NAME
DoRefractionSwitch \- Create a primitive attribute object for enabling or disabling the use of refraction
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoRefractionSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DORFRS(SWVAL)
INTEGER*4 SWVAL
.in  -.5i
.fi 
.IX "DoRefractionSwitch"
.IX "DORFRS"
.SH DESCRIPTION
.LP
\f2DoRefractionSwitch\fP creates a refraction switch primitive 
attribute object 
.LP
When light passes from one material to another the path of the light ray
is altered by refraction.
This can be seen, for example, when light passes from air to a
transparent material, such as glass or water.
.LP
The parameter \f2switchvalue\fP specifies whether subsequent 
primitive objects can alter the path of light rays that pass 
through them.
.IX DcOn
.IX DCON
.IP "\f2DcOn\fP <\f2DCON\fP>"
The object alters the path of light rays passing through it. 
.IX DcOff
.IX DCOFF
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
The object never alters the path of light rays passing through it.
.LP
The \f2DoRefractionSwitch\fP attribute is ignored if the
\f2DoTranspSwitch\fP <\f2DOTS\fP> is not turned on.
.SH DEFAULTS
The default \f2DoRefractionSwitch\fP is \f2DcOff\fP.
.SH SEE ALSO
.na
.nh
DoTranspSwitch(3D), 
DoRefractionIndex(3D)
.hy
.ad
\&
