.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSampleFilter 3D "Dore"
.SH NAME
DoSampleFilter \- Create a supersampling filter camera attribute object for antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSampleFilter(filter, xwidth, ywidth)
DtObject filter;
DtReal xwidth;
DtReal ywidth;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOSFLT(FILTER, XWIDTH, YWIDTH)
INTEGER*4 FILTER
REAL*8 XWIDTH
REAL*8 YWIDTH
.in  -.5i
.fi 
.IX "DoSampleFilter"
.IX "DOSFLT"
.SH DESCRIPTION
.LP
\f2DoSampleFilter\fP creates a supersampling filter camera 
attribute object for antialiasing.
\f2DoSampleFilter\fP is used in conjunction with \f2DoSampleSuper\fP.
.LP
Supersampling means that each pixel of an image is subdivided into
subpixels, and a shade is computed for each of the subpixels.
A filter is then applied to the shades of the subpixels to obtain
the final pixel value.
.LP
The computed pixel value is a weighted average of the subpixel shades,
typically with higher weights for subpixels closer to the pixel center.
The parameter \f2filter\fP specifies which filter function to use.
Possible values for \f2filter\fP are:
.IX DcFilterBox
.IX DCFBOX
.IP "\f2DcFilterBox\fP <\f2DCFBOX\fP>"
A box filter function is used.  
All subpixels under the filter footprint have equal weights.
.LP
The parameters \f2xwidth\fP and \f2ywidth\fP specify the size of the
filter footprint in output pixels.
For example, if \f2xwidth\fP and \f2ywidth\fP are both \f21.0\fP then
the filter footprint covers all the subpixels of a pixel.
If \f2xwidth\fP and/or \f2ywidth\fP are larger than \f21.0\fP then
the filters will overlap.
.SH DEFAULTS
The default \f2DoSampleFilter\fP is \f2(DcFilterBox, 1., 1.)\fP.
.SH SEE ALSO
.na
.nh
DoSampleSuper(3D),
DoSampleSuperSwitch(3D)
.ad
.hy
\&
