.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSampleSuperSwitch 3D "Dore"
.SH NAME
DoSampleSuperSwitch \- Create a camera attribute object for enabling or disabling the use of supersampling for antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSampleSuperSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOSSSW(SWVAL)
INTEGER*4 SWVAL
.in  -.5i
.fi 
.IX "DoSampleSuperSwitch"
.IX "DOSSSW"
.SH DESCRIPTION
.LP
\f2DoSampleSuperSwitch\fP creates a supersampling switch camera 
attribute object for antialiasing.
.LP
Supersampling means that each pixel of an image is subdivided into
subpixels, and a shade is computed for each of the subpixels.
A filter is then applied to the shades of the subpixels to obtain
the pixel value.
.LP
The parameter \f2switchvalue\fP specifies whether subsequent cameras
can do supersampling.
.IX DcOn
.IX DCON
.IP "\f2DcOn\fP <\f2DCON\fP>"
Supersampling is enabled. 
The number of subpixels per pixel is determined by the 
\f2DoSampleSuper\fP <\f2DOSSPR\fP> attribute.
.IX DcOff
.IX DCOFF
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
The pixels will not be divided into subpixels.
.SH DEFAULTS
The default \f2DoSampleSuperSwitch\fP is \f2DcOff\fP.
.SH SEE ALSO
.na
.nh
DoSampleSuper(3D),
DoSampleFilter(3D),
DoLocalAntiAliasStyle(3D),
DoLocalAntiAliasSwitch(3D)
.ad
.hy
\&
