.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSpecularColor 3D  "Dore"
.SH NAME
DoSpecularColor \- Create a specular color primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSpecularColor(colormodel, color)
DtColorModel colormodel;
DtReal color[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOSPCC(COLMOD, COLOR)
INTEGER*4 COLMOD
REAL*8 COLOR(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOSPCC
.IX DoSpecularColor
.I DoSpecularColor
creates a specular color primitive attribute object.  The parameter
\f2colormodel\fP specifies the color model used.
The parameter \f2color\fP
specifies the specular response of a surface to light
from directed light sources in the environment.
.PP
Specular reflection is the response of a surface to directed incident
light where the reflected (specular) light is scattered primarily in
the mirror direction.  
You can think of the specular chromatic response of a
surface as the color of its shiny highlights.
.PP
The specular color is only one of four qualities 
that give a surface shiny highlights.
The other aspects are the 
intensity of the color
(set with \f2DoSpecularIntens\fP), 
the precision of the highlight (set with \f2DoSpecularFactor\fP),
and the switch that turns
on the highlights (set with \f2DoSpecularSwitch\fP).
\f2DoSpecularColor\fP also affects the color of
interobject reflections.
.SH DEFAULTS
The default \f2DoSpecularColor\fP is (\f2DcRGB\fP, (1.0, 1.0, 1.0)).
.SH "SEE ALSO"
.na
.nh
DoSpecularIntens(3D), DoSpecularFactor(3D), DoSpecularSwitch(3D)
.ad
.hy
