.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoStereo 3D "Dore"
.SH NAME
DoStereo \- Create a stereo studio attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoStereo(eyeseparation,distance)
DtReal eyeseparation;
DtReal distance;
.in  -.5i
.sp
FORTRAN:
.in  +.5i
INTEGER*4 DOSTER(EYESEP,DISTNC)
REAL*8 EYESEP
REAL*8 DISTNC
.in  -.5i
.fi 
.SH DESCRIPTION
.IX DOSTER
.IX DoStereo
.PP
\f2DoStereo\fP returns a stereo studio attribute.
The attribute requires two input values to specify 
camera positioning for stereo.
The \f2eyeseparation\fP parameter is used to specify 
the distance from the normal camera position to each 
of the two stereo camera positions (one for each eye).
The total distance between the two camera positions
will be 2*\f2eyeseparation\fP.
The \f2distance\fP parameter
specifies the distance from the original camera position
to the point along the original camera direction vector
at which both stereo camera directions are centered.
This controls the ``focus'' point
and becomes important when the distance of the objects
being displayed is small enough that it approaches the
eye separation distance,
that is, when objects become ``close''.
Both parameters are specified in world units space.
.SH DEFAULTS
The default \f2eyeseparation\fP is 1.0.
The default \f2distance\fP is 10.0.
.SH SEE ALSO
DoStereoSwitch(3D)
