.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextAlign 3D  "Dore"
.SH NAME
DoTextAlign \- Create a text alignment primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextAlign(halign, valign)
DtTextAlignHorizontal halign;
DtTextAlignVertical valign;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTA(HALIGN, VALIGN)
INTEGER*4 HALIGN
INTEGER*4 VALIGN
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTA
.IX DoTextAlign
.I DoTextAlign
creates a text alignment primitive attribute object.  The parameters
specify the position of the text rectangle relative to the reference
point specified in subsequently executed text primitive objects.
The alignment depends on the value set by \f2DoTextPath\fP <\f2DOTPA\fP> 
to determine the
direction new characters are placed relative to the current text position.
See \f2DoTextPath\fP.
.PP
The parameter \f2halign\fP specifies the horizontal position of the text
rectangle relative to the reference point.  Possible values are:
.PP
.IP "\f2DcTextHAlignLeft\fP <\f2DCTHAL\fP>"
The left side of the text rectangle passes through the text position.
.IP "\f2DcTextHAlignCenter\fP <\f2DCTHAC\fP>"
The text position lies midway between the left and right sides of the text
rectangle.
.IP "\f2DcTextHAlignRight\fP <\f2DCTHAR\fP>"
The right side of the text rectangle passes through the text position.
.BP
.PP
.IP "\f2DcTextHAlignNormal\fP <\f2DCTHAN\fP>"
The most natural alignment is achieved by selecting from the other alignment
values based on the value of the current text path attribute.
.PP
The parameter \f2valign\fP specifies the vertical position of the text
rectangle relative to the reference point.  Possible values are:
.IP "\f2DcTextVAlignTop\fP <\f2DCTVAT\fP>"
The top of the text rectangle passes through the text position.
.IP "\f2DcTextVAlignCap\fP <\f2DCTVAC\fP>"
If the text path is \f2DcTextPathLeft\fP <\f2DCTPL\fP> or 
\f2DcTextPathRight\fP <\f2DCTPR\fP>,
the text position lies on the capline of the whole string.
If the text path is \f2DcTextPathUp\fP <\f2DCTPU\fP> or \f2DcTextPathDown\fP
<\f2DCTPD\fP>,
the text position lies on the capline of the topmost character.
.IP "\f2DcTextVAlignHalf\fP <\f2DCTVAH\fP>"
If the text path is \f2DcTextPathLeft\fP <\f2DCTPL\fP>
or \f2DcTextPathRight\fP <\f2DCTPR\fP>,
the text position lies on the halfline of the whole string.
If the text path is \f2DcTextPathUp\fP <\f2DCTPU\fP> or \f2DcTextPathDown\fP
<\f2DCTPD\fP>,
the text position lies on a line halfway between the halflines of the top and
bottom characters.
.IP "\f2DcTextVAlignBase\fP <\f2DCTVAB\fP>"
If the text path is \f2DcTextPathLeft\fP <\f2DCTPL\fP> or \f2DcTextPathRight\fP
<\f2DCTPR\fP>,
the text position lies on the baseline of the whole string.
If the text path is \f2DcTextPathUp\fP <\f2DCTPU\fP>
or \f2DcTextPathDown\fP <\f2DCTPD\fP>,
the text position lies on the baseline of the bottom character in the string.
.IP "\f2DcTextVAlignBottom\fP <\f2DCTVAM\fP>"
The bottom of the text rectangle passes through the text position.
.IP "\f2DcTextVAlignNormal\fP <\f2DCTVAN\fP>"
The most natural alignment is achieved by selecting from the other alignment
values based on the value of the current text path attribute.
.SH DEFAULTS
The default \f2DoTextAlign\fP is (\f2DcTextHAlignNormal\fP <\f2DCTHAN\fP>,
\f2DcTextVAlignNormal\fP <\f2DCTVAN\fP>).
.SH "SEE ALSO"
.na
.nh
DoAnnoText(3D), DoText(3D), DoTextExpFactor(3D), DoTextFont(3D),
DoTextHeight(3D), DoTextPath(3D), DoTextPrecision(3D), DoTextSpace(3D),
DoTextUpVector(3D)
.ad
.hy
