.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextPrecision 3D  "Dore"
.SH NAME
DoTextPrecision \- Create a text precision primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextPrecision(precision)
DtTextPrecision precision;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTPR(PRECIS)
INTEGER*4 PRECIS
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTPR
.IX DoTextPrecision
.I DoTextPrecision
creates a text precision primitive attribute object.  The parameter
\f2precision\fP specifies the accuracy with which text is drawn
for subsequently executed text primitive objects.  Possible values are:
.BP
.PP
.IP "\f2DcStringPrecision\fP <\f2DCSTRP\fP>"
The attributes used to render text objects are text font, text height, and text
expansion factor.  The text is clipped in a device-dependent manner.
.IP "\f2DcCharacterPrecision\fP <\f2DCCHRP\fP>"
The attributes used to render text objects are text font, text height,
text expansion factor, text up vector, text space, text path and text
alignment.  The text is clipped, at the least, on a character-by-character
basis.
.IP "\f2DcStrokePrecision\fP <\f2DCSTKP\fP>"
All text attributes are applied exactly and, if applicable, lighting and
shading calculations are also performed on the text primitive object.
.SH DEFAULTS
The default \f2DoTextPrecision\fP is \f2DcStrokePrecision\fP <\f2DCSTKP\fP>.
.SH "SEE ALSO"
.na
.nh
DoAnnoText(3D), DoText(3D), DoTextAlign(3D), DoTextExpFactor(3D), 
DoTextFont(3D), DoTextHeight(3D), DoTextPath(3D), DoTextSpace(3D),
DoTextUpVector(3D) 
.ad
.hy
