.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTranspOrientSwitch 3D "Dore"
.SH NAME
DoTranspOrientSwitch \- Create a primitive attribute object for enabling or disabling orientation dependent transparency
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTranspOrientSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOTOS(SWVAL)
INTEGER*4 SWVAL
.in  -.5i
.fi 
.IX "DoTranspOrientSwitch"
.IX "DOTOS"
.SH DESCRIPTION
.LP
\f2DoTranspOrientSwitch\fP creates a primitive attribute object for
enabling or disabling orientation dependent transparency.
.LP
Orientation dependent transparency means that the transparency of
an object varies depending on the orientation of the object and the 
view direction.
The transparency can also vary across the object if it is not 
completely flat.
.LP
The attributes \f2DoTranspIntens\fP <\f2DOTI\fP> and
\f2DoTranspColor\fP <\f2DOTC\fP> are used when the viewing
direction coincides with the object normal.
The values of the attributes \f2DoTranspOrientIntens\fP <\f2DOTOI\fP> and 
\f2DoTranspOrientColor\fP <\f2DOTOC\fP>
are used when the object normal is perpendicular to the viewing direction.
Otherwise a combination of both sets is used. 
See \f2DoTranspOrientIntens\fP and \f2DoTranspOrientColor\fP for more details.
.LP
The parameter \f2switchvalue\fP specifies whether subsequent 
primitive objects have an orientation dependent transparent component.
.IX DcOn
.IX DCON
.IP "\f2DcOn\fP <\f2DCON\fP>"
The object will render itself without orientation dependent transparency, 
regardless of the settings for other orientation dependent transparency 
attributes.
.IX DcOff
.IX DCOFF
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
The object will render itself with orientation dependent transparency whenever 
possible.
.LP
Both \f2DoTranspSwitch\fP <\f2DOTS\fP> and \f2DoTranspOrientSwitch\fP
must be \f2DcOn\fP for orientation dependent transparency
to be enabled.
.SH DEFAULTS
The default \f2DoTranspOrientSwitch\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH SEE ALSO
.na
.nh
DoTranspOrientIntens(3D),
DoTranspOrientColor(3D),
DoTranspOrientExp(3D),
DoTranspIntens(3D),
DoTranspColor(3D),
DoTranspSwitch(3D)
.hy
.ad
\&
