.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DpUpdVarLineList 3D  "Dore"
.SH NAME
DpUpdVarLineList \- Update a variable line list primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DpUpdVarLineList(object, linecount, vertlocs, 
		vertnorms, vertcolors)
DtObject object;
DtInt linecount;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DPUVLL(OBJECT, LINCNT, VTXLOC, 
		VTXNRM, VTXCLR)
INTEGER*4 OBJECT
INTEGER*4 LINCNT
REAL*8 VTXLOC(*)
REAL*8 VTXNRM(*)
REAL*8 VTXCLR(*)
.fi
.SH DESCRIPTION 
.IX DpUpdVarLineList
.IX DPUVLL
.I DpUpdVarLineList 
updates a variable 
line list primitive object.
.PP
The parameter \f2object\fP is the handle to the object. 
.PP
The parameter \f2linecount\fP specifies the number of lines in the 
vertex data arrays.  
A value of \f20\fP indicates that the number of lines has not changed.
.PP
The parameter \f2vertlocs\fP is an array of 
vertex locations.
If the vertex locations have not been modified use
\f2DcNullPtr\fP <\f2DCNULL\fP>. 
.PP
The parameter \f2vertnorms\fP is an array of vertex normals.
If the vertex normals have not been modified use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
\f2vertnorms\fP must be a null pointer if vertex normals were
not provided when the object was created with \f2DoVarLineList\fP <\f2DOVLNL\fP>.
.PP
The parameter \f2vertcolors\fP is an array of vertex colors.
If the vertex colors have not been modified use
\f2DcNullPtr\fP <\f2DCNULL\fP>. 
\f2vertcolors\fP must be a null pointer if vertex colors were 
not provided when the object was created with 
\f2DoVarLineList\fP <\f2DOVLNL\fP>.
.SH ERRORS
.I DpUpdVarLineList
will fail if an invalid object is specified.
.TP 15
[WARNING - invalid or deleted object]
.PP
.I DpUpdVarLineList
will fail if vertex normals are specified for an object that did not
possess them originally.
.TP 15
[WARNING - value out of range]
.PP
.I DpUpdVarLineList
will fail if vertex colors are specified for an object that did not
possess them originally.
.TP 15
[WARNING - value out of range]
.SH "SEE ALSO"
DoVarLineList(3D)
