.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DpUpdVarQuadGridUV 3D  "Dore"
.SH NAME
DpUpdVarQuadGridUV \- Update the \f2uv\fP texture coordinates of a variable quadrilateral grid primitive object 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DpUpdVarQuadGridUV(object, uvindex, uvlist)
DtObject object;
DtInt uvindex;
DtReal uvlist[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DPUQGV(OBJECT, UVIDX, UVLIST)
INTEGER*4 OBJECT
INTEGER*4 UVIDX
REAL*8 UVLIST(*)
.fi
.SH DESCRIPTION 
.IX DpUpdVarQuadGridUV
.IX DPUQGV
.I DpUpdVarQuadGridUV
updates one set of \f2uv\fP texture coordinates of a 
variable quadrilateral grid primitive object.
.PP
The parameter \f2object\fP is the handle to the variable
quadrilateral grid object. 
.PP
The parameter \f2uvindex\fP specifies which set of \f2uv\fP 
coordinates is being updated.
Note, the \f2uv\fP texture coordinates of a vertex are 
numbered from 0.
To \f2add\fP a new set of \f2uv\fP coordinates to the vertex data
of an object, set the \f2uvindex\fP to point to the next available
slot.
For example, for objects that do not have any \f2uv\fP coordinates,
a \f2uvindex\fP of 0 will create the initial set.
.PP
The parameter \f2uvlist\fP contains the new \f2uv\fP coordinates, one
for every vertex of the variable quadrilateral grid object.
As with other variable vertex data, Dore
does not make a copy of the \f2uv\fP coordinates.
It simply maintains pointers to the data in user space.
.SH ERRORS
.I DpUpdVarQuadGridUV
will fail if an invalid object is specified.
.TP 15
[WARNING - invalid or deleted object]
.PP
.I DpUpdVarQuadGridUV
will fail if \f2uvindex\fP is less than 0 or greater than
the next available slot for \f2uv\fP coordinates.
.TP 15
[WARNING - value out of range]
.SH "SEE ALSO"
DoVarQuadGrid(3D),
DpUpdVarQuadGridUVW(3D)
