.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInputValue 3D  "Dore"
.SH NAME
DsInputValue \- Post a value to an input slot
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsInputValue(slot, value)
DtObject   slot;
DtReal value;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSIV(SLOT, VALUE)
INTEGER*4   SLOT
REAL*8 VALUE
.in -.5i
.fi
.SH DESCRIPTION
.IX DSIV
.IX DsInputValue
.I DsInputValue
posts a floating point value to an input slot organizational object.
An input slot is an entry point for a \f2DtReal <REAL*8>\fP
value and provides the primary interface for connecting
input events and values to Dor\o.\(aae..
.PP
Each input slot has a group of 0 or more valuator callback objects.
A valuator is a callback object that depends upon input slots.
\f2DsInputValue\fP is used primarily to
achieve dynamic displays by using these input values to affect object
attributes or their geometry.  The input values can be generated by
application programs or by asynchronous external
events such as dial or mouse movement events.
.PP
When an input value arrives at an input slot, all valuator
callback objects dependent upon it are called.
.PP
The parameter \f2slot\fP specifies the input slot to which the 
\f2DtReal <REAL*8>\fP in parameter \f2value\fP is to be posted.
.SH ERRORS
\f2DsInputValue\fP will fail if passed an invalid slot handle.
.TP 15
[WARNING - invalid slot handle]
.SH "SEE ALSO"
.na
.nh
DoCallback(3D), DoInputSlot(3D), DsInqValuatorGroup(3D),
DsUpdateAllViews(3D), DsValuatorSwitch(3D)
.hy
.ad
