.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqObj 3D  "Dore"
.SH NAME
DsInqObj \- Obsolete function replaced by DsInqObjViaInteger and DsInqObjViaString
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DsInqObj(object_name_type, object_name, 
		class_id)
DtNameType object_name_type;
DtPtr object_name;
DtInt class_id;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DSQOI(OBJNUM, CLASID)
INTEGER*4 OBJNUM
INTEGER*4 CLASID

INTEGER*4 DSQOS(OBJSTR, N, CLASID)
INTEGER*4 N
CHARACTER*N OBJSTR
INTEGER*4 CLASID
.in -.5i
.fi
.SH DESCRIPTION
.IX DSQOI
.IX DSQOS
.IX DsInqObj
.I DsInqObj
returns a handle to an object.  
.LP
The parameter \f2object_name\fP specifies the name of the object.  
Note that objects are not named when they are created; it is the
application that names them using \f2DsSetObjName\f1.
.LP
The parameter \f2class_id\fP contains an integer indicating 
the class (or type) of the object being queried.
The integer representing a particular class can be determined using
\f2DsInqClassId(class_name)\fP where \f2class_name\fP is the C name of the
\f2DoXXXXX\fP function used to create an object.  For example,
\f2DsInqClassId("DoScale")\fP returns the integer class identification
value for a scale object.
.LP
The parameter \f2object_name_type\f1 specifies \f2object_name\f1's
type.  Possible values for \f2object_name_type\fP are:
.IP "\f2DcNameInteger <DCNINT>\fP
An integer value name.
.IP "\f2DcNameString <DCNSTR>\fP
A string value name.
.SH "FORTRAN SPECIFIC"
.LP
Function \f2DSQOS\fP queries the handle of an object when
the name is of type \f2DCNINT\fP.
\f2OBJNUM\fP is the integer name of the object and \f2CLASID\fP is
an integer value indicating the class (or type) of the object being queried.
The integer representing a particular class can be determined using
\f2DSQCI(CLSNME,N)\fP where \f2CLSNME\fP is the C name of the
\f2DoXXXXX\fP function used to create an object and \f2N\fP is the length
of the C name.  For example, \f2DSQCI('DoScale', 7)\fP returns the integer
class value for a scale object.
.LP
Function \f2DSQOI\fP queries the handle of an object when the object
name is of the type \f2DCNSTR\fP.  \f2OBJSTR\fP is a string of
\f2N\fP characters containing the name of the object.
\f2CLASID\fP is an integer value indicating the class (or type) of the
object being queried.
.SH ERRORS
.I DsInqObj
will fail if the \f2object_name_type\fP argument is invalid.
.TP 15
[WARNING - invalid parameter]
.SH "SEE ALSO"
DsInqClassId(3D), 
DsInqObjClassId(3D),
DsInqObjName(3D) 
