.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqObjName 3D  "Dore"
.SH NAME
DsInqObjName \- Obsolete function replaced by DsInqObjNameType, DsInqObjNameInteger
and DsInqObjNameString
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsInqObjName(object, object_name_type, 
		object_name)
DtObject object;
DtNameType *object_name_type;
DtPtr object_name;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DSQONT(OBJECT)
INTEGER*4 OBJECT
.sp
INTEGER*4 DSQONI(OBJECT)
INTEGER*4 OBJECT
.sp
CALL DSQONS(OBJECT, FNAME, LENGTH)
INTEGER*4 OBJECT
INTEGER*4 LENGTH
CHARACTER*LENGTH FNAME
.in -.5i
.fi
.SH DESCRIPTION
.IX DSQONT
.IX DSQONI
.IX DSQONS
.IX DsInqObjName
.I DsInqObjName
returns an object's name given its object handle.  The parameter \f2object\fP
specifies the object.
The parameter \f2object_name\fP is  for the returned object name.
The parameter \f2object_name_type\fP returns the type of the object name
that is passed back.
Possible return values for \f2object_name_type\fP are:
.PP
.IP "\f2DcNameInteger <DCNINT>\fP"
An integer value name.
.IP "\f2DcNameString <DCNSTR>\fP"
A string value name.  Object names are delimited by a trailing null.
.IP "\f2DcNameNone <DCNNON>\fP"
No name given.
.PP
Dore maintains a system wide object name table subdivided by class.
The \f2DsInqObjName\fP function can obtain the name of any object in this
table.
.SH "FORTRAN SPECIFIC"
.PP
.I DSQONT
returns the class (object type) of the object \f2OBJECT\fP.
.PP
.I DSQONI
returns the name of the object \f2OBJECT\fP.  This function
should be used when the object name is of type \f2DCNINT\fP (it's an integer).
.PP
.I DSQONS
returns the name of the object \f2OBJECT\fP.  This function
should be used when the object name is of type \f2DCNSTR\fP (it's a string).
The string name is returned in \f2FNAME\fP and is \f2LENGTH\fP characters long.
.SH ERRORS
.I DsInqObjName
will fail if the object handle is invalid.
.TP 15
[WARNING - invalid or deleted object]
.SH "SEE ALSO"
DsInqObj(3D)
