.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqObjNameType 3D  "Dore"
.SH NAME
DsInqObjNameType \- Return the name type of a given object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtNameType DsInqObjNameType (object)
.in  +.5i
DtObject object;
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DSQONT(OBJECT)
INTEGER*4 OBJECT
.in  -.5i
.fi
.SH DESCRIPTION
.IX DsInqObjNameType
.I DsInqObjNameType
returns the name type of the given object.  Possible return values are:
.PP
.IP "\f2DcNameInteger <DCNINT>\fP"
The specified object has an integer value name.
.IP "\f2DcNameString <DCNSTR>\fP"
The specified object has a string value name.
.IP "\f2DcNameNone <DCNNON>\fP"
The object has not been named.
.PP
The parameter \f2object\fP specifies the object that is queried.
.SH ERRORS
.I DsInqObjNameType
will fail if the object is invalid.
.TP 15
[WARNING - invalid or deleted object]
.SH "SEE ALSO"
.nf
DsInqObjNameInteger(3D), DsInqObjNameString(3D),
DsInqObjViaInteger(3D), DsInqObjViaString(3D),
DsSetObjNameInteger(3D), DsSetObjNameString(3D)
