.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqRendererId 3D "Dore"
.SH NAME
DsInqRendererId \- Return the renderer identifier of a named renderer
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtInt DsInqRendererId(renderer_name)
DtPtr renderer_name;
.in  -.5i
.sp
FORTRAN:
.in  +.5i
INTEGER*4 DSQRI(RENNME, N)
CHARACTER*N RENNME
.in -.5i
.fi
.SH DESCRIPTION
.IX DsInqRendererId
.IX "DSQRI"
.LP
\f2DsInqRendererId\fP returns the integer identifier 
of the renderer with the string name \f2renderer_name\fP.
If \f2renderer_name\fP is not the name of a renderer installed
in the current Dore system, \f2DsInqRendererId\fP returns -1.
The renderer identifier can be used to select
the renderer with \f2DvSetRendStyle <DVSRS>\fP.
.SH FORTRAN SPECIFIC
.LP
The \f2RENNME\fP parameter is the renderer name string, which is
\f2N\fP characters long.
.SH "SEE ALSO"
.na
.nh
DsInqNumRenderers(3D), DsInqRendererNames(3D), DvInqRendStyle(3D)
.ad
.hy
