.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsRadiosityInitialize 3D  "Dore"
.SH NAME
DsRadiosityInitialize \- Initialize Dore  radiosity.
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsRadiosityInitialize()
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSRDIN()
.in -.5i
.fi
.IX  "DsRadiosityInitialize"
.IX  "DSRDIN"
.SH DESCRIPTION
.I DsRadiosityInitialize
initializes a utility used by
some renderers to calculate radiosity.
A call to \f2DsRadiosityInitialize\fP must immediately follow
the call to \f2DsInitialize\fP.
Multiple calls to \f2DsRadiosityInitialize\fP are ignored.
Use \f2DoRadiositySwitch <DORADS> \fP to enable
radiosity in a scene.
.SH ERRORS
DsRadiosityInitialize will issue an error if it was not called
immediately after DsInitialize.
.TP 15
[SEVERE - Can't init radiosity]
.SH "SEE ALSO"
.nh
.na
DoRadiositySwitch(3D),
DvSetRadiosityUpdateType(3D)
.ad
.hy
