.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsRasterUpdate 3D "Dore"
.SH NAME
DsRasterUpdate \- Update a raster object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DsRasterUpdate(raster)
DtObject raster;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
DSRSU(RASTER)
INTEGER*4 RASTER
.in  -.5i
.fi 
.IX "DsRasterUpdate"
.IX "DSRSU"
.SH DESCRIPTION
.LP
\f2DsRasterUpdate\fP notifies Dore that the data for a raster object
has changed.
.LP
The parameter \f2raster\fP is a handle to the raster object.
.LP
.SH ERRORS
\f2DsRasterUpdate\fP will fail if \f2raster\fP is not a valid raster object.
.TP 15
[WARNING - invalid or deleted object]
.SH SEE ALSO
.na
.nh
DoRaster(3D), DsInqRaster(3D)
.ad
.hy
\&
