.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetRadiosityConvergence 3D  "Dore"
.SH NAME
DvSetRadiosityConvergence \- Set the radiosity convergence criterion for a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetRadiosityConvergence(view, type, parms)
DtObject view ;
DtRadiosityConvType type;
DtReal parms[];
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVSRDC(VIEW,TYPE,PARMS)
INTEGER*4 VIEW
INTEGER*4 TYPE
REAL*8 PARMS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DVSRDC
.IX DvSetRadiosityConvergence
.I DvSetRadiosityConvergence
sets the radiosity convergence criterion for a view.
This applies to progressive radiosity techniques in which intermediate images
are computed until a certain criterion or threshold is met.
Possible type values are:
.PP
.IP "\f2DcConvFixedIterations\fP <\f2DCCVFI\fP>"
Perform a fixed number of iterations specified in \f2parms[0]\fP.
.IP "\f2DcConvGlobalRel\fP <\f2DCCVGR\fP>"
Stop when the ratio of the total unshot energy 
over the total energy in the scene is smaller or equal to \f2parms[0]\fP.
.IP "\f2DcConvGlobalAbs\fP <\f2DCCVGA\fP>"
Stop when the total unshot energy 
in the scene is smaller or equal to \f2parms[0]\fP.
.IP "\f2DcConvPatchRel\fP <\f2DCCVPR\fP>"
Stop when the ratio of the
unshot energy of the brightest patch
over the total energy in the scene is smaller or equal to \f2parms[0]\fP.
The brightest patch is the patch with the maximum unshot energy.
.IP "\f2DcConvPatchAbs\fP <\f2DCCVPA\fP>"
Stop when the unshot energy of the brightest patch
in the scene is smaller or equal to \f2parms[0]\fP.
.PP
The initial scene displays the emissive objects with some intensity,
and the rest of the objects as black. During this first iteration,
the total energy in the scene is computed as:
.sp
       Sum  Emission(i) * EmissionFactor(i) * area(i)
        i
.sp
for all patches i. This sum is computed on a channel basis (r,g,b) and the
three values are summed to get the total energy. After every iteration,
the total unshot energy is computed, and the unshot energy of the brightest
patch is recorded. The iterative process stops whenever the criteria is met,
or when the unshort energy in the scene drops below 1e-10.
If the total unshot energy in the scene drops below a negligible
amount, the solution is complete and is equivalent to the one resulting
from using a non-progressive radiosity algorithm.

.SH ERRORS
.I DvSetRadiosityConvergence
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH DEFAULTS
The default convergence \f2type\fP is \f2DcConvGlobalRel\fP <\f2DCCVGR\fP>
with \f2parms[0]\fP equals to 0.1 (below ten percent of the global energy
remains to be shot).
.SH "SEE ALSO"
.na
.nh
DvInqRadiosityConvergence(3D),
DoRadiositySwitch(3D),
DoIntermediateDispType(3D)
.ad
.hy
