.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetRendStyle 3D  "Dore"
.SH NAME
DvSetRendStyle \- Set the rendering style of a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetRendStyle(view, renderstyle)
DtObject view ;
DtRenderStyle renderstyle ;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVSRS(VIEW, RNDSTL)
INTEGER*4 VIEW 
INTEGER*4 RNDSTL 
.in -.5i
.fi
.SH DESCRIPTION
.IX DVSRS
.IX DvSetRendStyle
.I DvSetRendStyle
sets the rendering style of the view specified by the parameter \f2view\fP.
The parameter \f2renderstyle\fP is a top level selection of the rendering
process.  
Most Dore configurations include at least the following rendering
styles:
.PP
.IP "\f2DcRealTime\fP <\f2DCRLTM\fP>"
Fast, interactive display rendering.  This renderer runs fast enough for
dynamic operations that require continuous updates. 
.IP "\f2DcProductionTime\fP <\f2DCPRTM\fP>"
Slower, most realistic rendering.  This renderer does the most sophisticated
rendering within the user's requested parameters.  
Dore may economize
if the application's parameters negate the effect of the time-intensive
techniques.
.PP
The actual techniques used by each of these \f2renderstyle\fPs may
change with different Dore system configurations;
the trade-off of time and realism should remain
the same.
.PP
The value of \f2renderstyle\fP is a renderer identifier. 
Using a renderer identifier other than the dynamic renderer
identifier and the standard production renderer identifier will 
select a new renderer, if the renderer has been
installed in your Dore configuration.
\f2DsInqNumRenderers <DSQNR>\fP
and \f2DsInqRendererNames <DSQRNS>\fP
return information about the installed renderers.
See also
your \f2Dore System Guide\fP.
.SH ERRORS
.I DvSetRendStyle
will fail if the view is invalid. 
.TP 15
[WARNING - invalid view handle]
.SH DEFAULTS
The default render style is \f2DcRealTime\fP <\f2DCPRTM\fP>.
.SH "SEE ALSO"
DvInqRendStyle(3D)
