.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvUpdate 3D  "Dore"
.SH NAME
DvUpdate \- Redisplay the specified view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvUpdate(view)
DtObject view;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVU(VIEW)
INTEGER*4 VIEW
.in -.5i
.fi
.SH DESCRIPTION
.IX DVU
.IX DvUpdate
.I DvUpdate
causes the view, \f2view\fP, to update itself.
Depending on the update type (set by \f2DvSetUpdateType\fP <\f2DVSUT\fP>),
\f2DvUpdate\fP will update only display objects within the view, or
display objects and studio objects within the view.
.SH ERRORS
.I DvUpdate
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.PP
.I DvUpdate
will fail if Dore is already performing a traversal of the database.
.PP
[WARNING - traversal already in progress]
.SH "SEE ALSO"
.na
.nh
DdUpdate(3D), DfUpdate(3D), DvSetClearFlag(3D), DvSetRendStyle(3D)
.ad
.hy
