#ifndef _spline_ed.h
#define _spline_ed.h

#include <gl/gl.h>
#include <stdio.h>
#include "debug.h"

void	plot_t_spline(long gid,float coeff[4][3],float t);
float	solve_3order(float,float,float,float);
float	solve_2order(float,float,float);
void 	plot_point(long ,long, float ,float );
void 	plot_dbg_spline(long ,float a[4][3] );


// Window Viewport Size, used for ORTHO and misc scaling caclulations
#define XMIN (-100)	// always keep here for border
#define XMAX  900
#define	YMIN  (-50)
#define YMAX  500
#define ZMIN (-100)
#define ZMAX  100


class spline_cntrl_points {
    
  public:
    char	title[50];	
    long	id;		// unique ID number

    spline_cntrl_points(int);
    ~spline_cntrl_points();
   
    float xpos(int i) { return(pnts[i*3]); }
    float ypos(int i) { return(pnts[i*3+1]); }  
    
    void eq(int i,float x,float y) {pnts[i*3]=x; pnts[i*3+1]=y; }
    void add_pnt(int i,float x,float y);
    void del_pnt(int i);
    
    void calc_coeff();	
    float value(float xpos);
    
    void draw(float st_x, float end_x); // draw subregion
    void draw();			// draw whole spline
    
    
  private:
    int num_pts;
    float *pnts;

};

#endif
