/*
 * Demonstrates using "stuff" to send ASCII-format OOGL objects to Minneview.
 *
 * For visible results, run
 *	MinneView -M it &
 * while running this program.
 */

#include <stdio.h>
#include <math.h>

#define NU 10		/* Mesh size */
#define	NV 15

#define	TWOPI  6.283185

float p[NV][NU][3];

main()
{
    int i, j, done=0;
    float s, c;
    float xphase, xfreq, yphase, yfreq;
    FILE *f;

    /*
     * Pipe to "stuff" program, writing shared-memory object "it".  The
     * "popen" system call opens a pipe to the specified program.  An
     * alternate way of doing this would be for this program to write to
     * stdout (eliminating the call to popen), and use the shell to pipe
     * its output to stuff, as in "stuffdemo | stuff it".
     */
     f = popen("stuff it", "w");

     xphase = 0.5;
     yphase = 0.0;
     xfreq = 0.5;
     yfreq = 0.5;

    /*
     * The following loop never exits.  Use ^C to exit program.
     */
     while (!done) {

	/*
	 * Construct object
	 */
	for(i = 0; i < NV; i++) {
	    float v = (float) i / NV;
	    float xv = cos(TWOPI * (xphase + xfreq * v));

	    for(j = 0; j < NU; j++) {
		float u = (float) j / NU;
		float yv = cos(TWOPI*(yphase + yfreq * u));

		p[i][j][0] = u;	/* X */
		p[i][j][1] = v; /* Y */
		p[i][j][2] = (xv + yv)/3;
	    }
	}
	/*
	 * Write MESH object
	 */
	fprintf(f, "MESH\n");
	fprintf(f, "%d %d\n", NU, NV);
	for(i = 0; i < NV; i++) {
	    for(j = 0; j < NU; j++) {
		fprintf(f, "%g %g %g\n", p[i][j][0], p[i][j][1], p[i][j][2]);
	    }
	}
	/*
	 * Mark end of object so "stuff" will know we're done.
	 */
	fprintf(f, ";");
	fflush(f);

	/*
	 * Wait.  This isn't essential, but saves load on the system.
	 * sginap(n) is an Iris-specific system call which waits n/100 seconds.
	 */
	sginap(20);

	/*
	 * Update
	 */
	xphase += xfreq * .1;
	yphase -= yfreq * .2;
    }

    /*
     * Clean up upon exit.
     * (Irrelevant here since the above loop never exits.)
     */
    pclose(f);
    exit(0);
}

