/*
### Read the input pending on the pipe ###
*/ 

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>

Notify_value exec_pipe_reader(item,fd)
Panel_item item;
int fd;
{
	int i,result,save_option_old,lock_interval_old;
	extern int save_option,region_index,lock_interval;
	extern int aux_max;
	extern int *aux_on,*aux_win_mode;
	extern char exec_file_name[],error_mess[],error_yes[],error_no[];
	extern FILE *fp_fromchild;

	lock_interval_old = lock_interval;
	lock_interval = 0;
	if(region_index==2){
		/* aux_win_i runs from 0 to aux_max-1 */
		/* Count the number of open auxiliary windows */
		for(i=0;i<aux_max;i++){
			if(!aux_on[i]){
				/* Turn on aux_win_mode of chosed aux window */
				aux_win_mode[i]=1;

				/* Create_aux_window turns on aux_on */
				(void) create_aux_windows(i);

				/* Load data from a file pointer fp_fromchild
				This does the displaying and recording, too.  */
				load_data(fp_fromchild);

				/* Refresh the panel items of aux panel */
				all_refresh();
				return(NOTIFY_DONE);
			}
		}
		/* All the auxiliary windows are used up. Take over one. */
		for(i=0;i<aux_max;i++){

			if(i==0){
				sprintf(error_mess,"No more aux windows. Take over aux_win[%d]?",i);
				sprintf(error_yes,"Confirm");
				if(i != aux_max-1){
					sprintf(error_no,"No. Move to next aux_win[%d]",i+1);
				}
				else {
					sprintf(error_no,"");
				}
			}
			else if(i<aux_max-1){
				sprintf(error_mess,"How about this aux_win[%d]?",i);
				sprintf(error_yes,"Confirm");
				sprintf(error_no,"Nope. Next!");
			}
			else {
				sprintf(error_mess,"This is the last chance. Do you want get aux_win[i]?",i);
				sprintf(error_yes,"Confirm");
				sprintf(error_no,"Cancel. Exit!");
			}
			result = (int) error_mess_proc(error_mess,error_yes,error_no);
			if(result){
				/* Turn on aux_win_mode of chosed aux window */
				aux_win_mode[i]=1;
				(void) destroy_aux_windows(i);
				/* Create_aux_window turns on aux_on */
				(void) create_aux_windows(i);

				/* Load data from a file pointer fp_fromchild
				This does the displaying and recording, too.  */
				load_data(fp_fromchild);

				/* Refresh the panel items of aux panel */
				all_refresh();
				return(NOTIFY_DONE);
			}
		}
	}
	else {
		/* Load_data may change the save option */
		save_option_old = save_option;
		if(save_option==0){
			sytsem_mess_proc(1,"Change the save option to either 2-D data or Full data.");
			return(NOTIFY_DONE);
		}
		load_data(fp_fromchild);
		all_refresh();
		save_option = save_option_old;
	}
	lock_interval = lock_interval_old;
	return(NOTIFY_DONE);
}
