/*
### reset all parameters to default configuration as specified in model definition ###

Set the period to the default value: 0 for vector field and 1 for maps.
*/

reset_params()
{
	int i;
	extern int func_on,var_dim,func_dim,full_dim,param_dim,param_dim_max,all_dim_max,enable_polar,polar_coord;
	extern double *win_var_i,*var_i,*var_polar_i;
	extern double *all_min,*all_max,*var_polar_min,*var_polar_max,*var_min,*var_max,*func_min,*func_max,*param_min,*param_max;
	extern double *param_min_top,*param_max_top,*func_min_top,*func_max_top,*var_min_top,*var_max_top,*all_min_top,*all_max_top;
	extern char **all_label,**win_var_label,**param_label,**var_polar_label,**var_label,**func_label;
	
	/* initial box size = top box size */
	if(enable_polar!=0 && polar_coord) {
		for (i = 0; i < var_dim; i++) {
			win_var_i[i] = var_polar_i[i];
			win_var_label[i] = var_polar_label[i];
			all_label[i] = var_polar_label[i];
			all_min[i] = var_polar_min[i];
			all_max[i] = var_polar_max[i];
			all_min_top[i] = var_polar_min[i];
			all_max_top[i] = var_polar_max[i];
		}
	}
	else {
		for (i = 0; i < var_dim; i++) {
			win_var_i[i] = var_i[i];
			win_var_label[i] = var_label[i];
			all_label[i] = var_label[i];
			all_min[i] = var_min[i];
			all_max[i] = var_max[i];
			all_min_top[i] = var_min[i];
			all_max_top[i] = var_max[i];
		}
	}
	if(func_on){
		for(i=0;i<func_dim;i++){
			win_var_label[i+var_dim] = func_label[i];
			all_label[i+var_dim] = func_label[i];
			all_min[i+var_dim] = func_min[i];
			all_max[i+var_dim] = func_max[i];
			all_min_top[i+var_dim] = func_min[i];
			all_max_top[i+var_dim] = func_max[i];
		}
	}
	for(i=full_dim;i<all_dim_max;i++){
		win_var_label[i] = "~";
	}
	for(i=0;i<param_dim;i++){
		param_min_top[i] = param_min[i];
		param_max_top[i] = param_max[i];
		all_label[i+full_dim] = param_label[i];
		all_min[i+full_dim] = param_min[i];
		all_max[i+full_dim] = param_max[i];
		all_min_top[i+full_dim] = param_min[i];
		all_max_top[i+full_dim] = param_max[i];
	}
	for(i=param_dim;i<param_dim_max;i++){
		param_label[i] = "~";
	}
	for(i=full_dim+param_dim;i<all_dim_max;i++){
		all_label[i] = "~";
	}
}
