/* public.c: routines for public access */

#include <stdio.h>
#include <X11/Xlib.h>
#include "box_types.h"
#include "box_global.h"

/* Routines to get at box selections */


BoxStateChange(status)

VOID *status;

{
  BoxStatus *gnrc;

  gnrc = (BoxStatus *) status;

  if(gnrc->state_change == BOX_YES) {
     gnrc->state_change = BOX_NO;
     return(1);
    }
  else {
     return(0);
    }
}

ExtractBoxTopWindow(status)
VOID *status;
{
  BoxStatus *gnrc;
  gnrc= (BoxStatus *) status;
  return((int) (gnrc->TopWindow));
}

ExtractBoxSelection(status,choice)

VOID *status;
int *choice;

/* Returns the selection id heierarchy (derived from current_box)
   in choice, which is assumed to have enough space.  Return value
   is the number of choices.  */

{
  BoxStatus *gnrc;
  BoxList *bx;
  int i,num;

  gnrc = (BoxStatus *) status;
  bx = gnrc->select_box;
  num = bx->generation;

  i = num-1;
  while(bx !=  &(gnrc->box)) {
      choice[i] = bx->id;
      i--;
      bx = bx->parent;
     }
  gnrc->select_box = &(gnrc->box);
  return(num);
}

ExtractBoxTextEntryText(status,id,buff)

VOID *status;
int id;
char *buff;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx->type != BOX_TEXT_ENTRY) return(-1);

  strcpy(buff,bx->dflt.text);
  return(0);
}

ExtractBoxSliderValue(status,id,value)

VOID *status;
int id;
double *value;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx->type != BOX_HORIZONTAL_SLIDER && bx->type != BOX_VERTICAL_SLIDER)
     return(-1);

  *value = bx->value;
  return(0);
}


ExtractBoxToggleState(status,id,boolean)

VOID *status;
int id;
int *boolean;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx->type !=  BOX_TOGGLE)
     return(-1);

  if(bx->state == BOX_YES) *boolean = 1;
  else *boolean = 0;
  return(0);
}

ExtractBoxDimensions(status,id,x,y,width,height)

VOID *status;
int id;
int *x,*y,*width,*height;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  *x = bx->x; *y = bx->y;
  *width = bx->width; *height = bx->height;
  return(0);
}

/* Routines to modify essential box variables */


ChangeBoxSliderValue(status,box_id,value)

VOID *status; int box_id; double value;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,box_id);
  if(bx->type != BOX_HORIZONTAL_SLIDER &&
             bx->type != BOX_VERTICAL_SLIDER) {
     fprintf(stderr,"Box not slider.\n"); return(0);
    }
  bx->value = value;
  DrawBox(gnrc,bx);
}


ChangeBoxTextPrompt(status,box_id,prompt,attr_id)

VOID *status;
int box_id,attr_id;
char *prompt;

{
  BoxStatus *gnrc;
  BoxList *bx;
  BoxAttributeList *attr;
  TextList *txt;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,box_id);
  if(bx->type != BOX_TEXT_ENTRY) {
     fprintf(stderr,"Box not text entry.\n"); return(0);
    }
  attr = FindBoxAttributeByID(gnrc,attr_id);
  txt = &(bx->prompt);
  strcpy(txt->text,prompt);
  txt->x = BOX_PAD; txt->y = (bx->height + attr->fth)/2;
  txt->attr = attr;
  DrawBox(gnrc,bx);
}



ChangeBoxTextDefault(status,box_id,dflt,attr_id)

VOID *status;
int box_id,attr_id;
char *dflt;

{
  BoxStatus *gnrc;
  BoxList *bx;
  BoxAttributeList *attr;
  TextList *txt;
  char *strng;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,box_id);
  if(bx->type != BOX_TEXT_ENTRY) {
     fprintf(stderr,"Box not text entry.\n"); return(0);
    }
  attr = FindBoxAttributeByID(gnrc,attr_id);
  txt = &(bx->dflt);
  strcpy(txt->text,dflt);
  strng = bx->prompt.text;  /* Prompt string */
  txt->x = BOX_PAD + XTextWidth(attr->fontstruct,strng,strlen(strng));
  txt->y = (bx->height + attr->fth)/2;
  txt->attr = attr;
  DrawBox(gnrc,bx);
}


ChangeBoxToggleState(status,box_id,state)

VOID *status;
int box_id,state;

{
  BoxStatus *gnrc;
  BoxList *bx,*parent,*child;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,box_id);
  if(bx->type != BOX_TOGGLE) {
     fprintf(stderr,"Box not text entry.\n"); return(0);
    }
  if(state == 1) bx->state = BOX_YES;
  else bx->state = BOX_NO;
  DrawBox(gnrc,bx);

  /* check exclusivity of parent */
  parent = bx->parent;
  if(parent->exclusive == BOX_YES) {
     child = parent->child;
     while(child != NULL) {
         if(child->state == BOX_YES && child != bx &&
              child->type == BOX_TOGGLE) {
            child->state = BOX_NO; DrawBox(gnrc,child);
           }
         child = child->sibling;
        }
    }

}


/* Routines for external control of box selection and display */

SelectBoxByID(status,id)

VOID *status;
int id;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  if((bx = FindBoxByID(gnrc,id)) == NULL) {
     BoxPrintMessage(gnrc,"Invalid box!.");
    }

  /* Check if valid choice of box */
  if(!BoxIsValidChoice(gnrc,bx)) {
    BoxPrintMessage(gnrc,"Current selection must be completed.");
    return(-1);
   }

  BoxSelect(gnrc,bx);
}

BoxPublicKeyPress(status,key)

VOID *status;
char key;

{
  BoxStatus *gnrc;

  gnrc = (BoxStatus *) status;
  BoxKeyPress(gnrc,key);
  
}

DrawBoxByID(status,id)

VOID *status;
int id;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  DrawBox(gnrc,bx);
}


CreateBox(status,type,x,y,width,height)

VOID *status;
int type,x,y,width,height;

/* Routine creates a new box with default settings.  Returns the id */
/* of the box, or -1 if an error condition is encountered */

{
  BoxStatus *gnrc;
  int id,length;
  BoxList *bx;
  TextList *txt;

  gnrc = (BoxStatus *) status;
  id = 1;
  bx = &(gnrc->box); 

  while(bx->next != NULL) {
    id++;
    bx = bx->next;
   }

  bx->next = (BoxList *) malloc(sizeof(BoxList));
  bx = bx->next;
  if(bx == NULL) {
    fprintf(stderr,"Unable to allocate space for new box.\n");
    return(-1);
   }

  bx->x = x; bx->y = y;
  bx->width = width; bx->height = height;
  
  bx->type = type; bx->id = id;
  bx->generation = 1; bx->visible = BOX_YES;
  bx->state = BOX_NO; bx->border = BOX_YES; bx->key = '\0';  
  bx->exclusive = BOX_NO; bx->always_visible = BOX_NO;
  bx->induce_state_change = BOX_YES;
  bx->cleanup = BOX_NO;
  bx->stop_cleanup = BOX_NO;

  bx->next = NULL; bx->child = NULL; bx->sibling = NULL;
  bx->friend = NULL; bx->parent = &(gnrc->box);

  bx->data = (VOID *) NULL;
  bx->btmp.next = NULL;
  bx->dsn.next = NULL;
  bx->txt.next = NULL;
  bx->local_callback = NULL;
  bx->global_callback = NULL;
  bx->continuous_local_callback = NULL;
  bx->continuous_global_callback = NULL;
  bx->global_arg = (VOID *) NULL;

  /* Type specific stuff */
  switch(type) {
     case BOX_MENU:
       bx->cleanup = BOX_YES;
     case  BOX_TEXT_ENTRY:  /* Create prompt and default */
       bx->prompt.text[0] = '\0'; bx->prompt.attr = &(gnrc->attribute);
       bx->dflt.text[0] = '\0'; bx->dflt.attr = &(gnrc->attribute);
       break;

     case BOX_HORIZONTAL_SLIDER:
     case BOX_VERTICAL_SLIDER:
       bx->value = 0.5;
       break;
    }
  return(id);
}



ToggleBoxAlwaysVisible(status,id,boolean)

VOID *status; int id,boolean;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  bx->always_visible = boolean;
}

ToggleBoxExclusive(status,id,boolean)

VOID *status; int id,boolean;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  bx->exclusive = boolean;
}

ToggleBoxStopCleanup(status,id,boolean)

VOID *status; int id,boolean;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  bx->stop_cleanup = boolean;
}

ToggleBoxCleanup(status,id,boolean)

VOID *status; int id,boolean;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  bx->cleanup = boolean;
}

ToggleBoxInduceStateChange(status,id,boolean)

VOID *status; int id,boolean;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  bx->induce_state_change = boolean;
}

ChangeBoxKey(status,box_id,key)

VOID *status; int box_id; char key;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,box_id);
  bx->key = key;
}


AddBoxChild(status,child_id,parent_id) 

VOID *status;
int child_id,parent_id;

{
  BoxStatus *gnrc;
  BoxList *child,*parent,*temp;

  gnrc = (BoxStatus *) status;

  child = FindBoxByID(gnrc,child_id);
  parent = FindBoxByID(gnrc,parent_id);

  if(child == NULL || parent == NULL) {
     fprintf(stderr,"Parent or child does not exist!\n");
     return(0);
    }

  child->parent = parent;
  child->generation = 1 + parent->generation;
  child->visible = BOX_NO; /* Default setting */

  if(parent->child == NULL) {
     parent->child = child;
    }
  else { /* Add child to sibling list of last child */
     temp = parent->child;
     while(temp->sibling != NULL) {
        temp = temp->sibling;
        }
     temp->sibling = child;
    }

  /* Change some flags in parent */
  switch(parent->type) {
     case BOX_MENU:
       parent->induce_state_change = BOX_NO;
       parent->cleanup = BOX_NO;
       break;
    }
}

AddBoxGlobalArg(status,id,arg)

VOID *status;
int id;
VOID *arg;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx == NULL) {
    fprintf(stderr,"Cannot add callback: box does not exist with that id.\n");
    return(0);
   }
  bx->global_arg = arg;
}

AddBoxLocalCallback(status,id,callback)

VOID *status;
int id;
int (*callback)();

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx == NULL) {
    fprintf(stderr,"Cannot add callback: box does not exist with that id.\n");
    return(0);
   }
  bx->local_callback = callback;
}


AddBoxGlobalCallback(status,id,callback)

VOID *status;
int id;
int (*callback)();

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx == NULL) {
    fprintf(stderr,"Cannot add callback: box does not exist with that id.\n");
    return(0);
   }
  bx->global_callback = callback;
}

AddBoxContinuousLocalCallback(status,id,callback)

VOID *status;
int id;
int (*callback)();

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx == NULL) {
    fprintf(stderr,"Cannot add callback: box does not exist with that id.\n");
    return(0);
   }
  bx->continuous_local_callback = callback;
}


AddBoxContinuousGlobalCallback(status,id,callback)

VOID *status;
int id;
int (*callback)();

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id);
  if(bx == NULL) {
    fprintf(stderr,"Cannot add callback: box does not exist with that id.\n");
    return(0);
   }
  bx->continuous_global_callback = callback;
}



ChangeBoxVisibility(status,id,visible)

VOID *status;
int id,visible;

{
  BoxStatus *gnrc;
  BoxList *bx;

  gnrc = (BoxStatus *) status;
  bx = FindBoxByID(gnrc,id); bx->visible = visible;
}

AddBoxText(status,box_id,x,y,strng,attr_id)

VOID *status;
int box_id,x,y,attr_id;
char *strng;

{
  BoxList *bx;
  BoxStatus *gnrc;
  TextList *txt;
  BoxAttributeList *attr;

  gnrc = (BoxStatus *) status;

  if((bx = FindBoxByID(gnrc,box_id)) == NULL) {
     fprintf(stderr,"No such box!\n"); return(0);
    }
  if((attr = FindBoxAttributeByID(gnrc,attr_id)) == NULL) {
     fprintf(stderr,"No such attribute!\n"); return(0);
    }
  txt = &(bx->txt);
  while(txt->next != NULL) txt = txt->next;
  txt->next = (TextList *) malloc(sizeof(TextList));
  if((txt = txt->next) == NULL) {
     fprintf(stderr,"Could not allocate space for text!\n"); return(0);
    }
  strcpy(txt->text,strng); txt->x = x; txt->y = y;
  txt->attr = attr; txt->next = NULL;
}

BoxPublicPrintMessage(status,mssg)

VOID *status;
char *mssg;

{
  BoxStatus *gnrc;

  gnrc = (BoxStatus *) status;
  BoxPrintMessage(gnrc,mssg);
}

BoxPublicUrgentWindowDialogue(status,prmpt,rtrn)

VOID *status;
char *prmpt,*rtrn;

{
  BoxStatus *gnrc;
  int num;

  gnrc = (BoxStatus *) status;
  num = BoxUrgentWindowDialogue(gnrc,prmpt,rtrn);
  return(num);
}

BoxShow(status)
VOID *status;
{
  BoxStatus *gnrc;
  gnrc = (BoxStatus *) status;

  XMapWindow(dpy,gnrc->TopWindow);
}

BoxHide(status)
VOID *status;
{
  BoxStatus *gnrc;
  gnrc = (BoxStatus *) status;

  XUnmapWindow(dpy,gnrc->TopWindow);
}

