#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "link_types.h"
#include "link_global.h"


LinkPrintLink(gnrc,fp,lnk)
LinkStatus *gnrc; FILE *fp; LinkList *lnk;
/* Prints out coordinate data for strand */
/* Routine does not print initial Strand id, but does print End */
{
  LinkPointList *pnt;

  fprintf(fp,"  closed %d\n",lnk->closed);
  fprintf(fp,"  data %d\n",lnk->num);
  pnt = lnk->point.next;
  while(pnt != NULL) {
     fprintf(fp,"    %.4lf  %.4lf  %.4lf\n",pnt->x,pnt->y,pnt->z);
     pnt = pnt->next;
    }
  fprintf(fp," End\n\n");
  return(0);
}

LinkPrintStrandPS(gnrc,fp,lnk)
LinkStatus *gnrc; FILE *fp; LinkList *lnk;
/* Prints out PS file for the lnk, using millimeters as fundamental unit */
{
  LinkPointList *pnt,*nxt;
  pnt = lnk->point.next;
  if(pnt == NULL) return(0);

  while(pnt != NULL) {
     LinkPrintEdgePS(gnrc,fp,lnk,pnt);
     pnt = pnt->next;
    }
}

LinkPrintEdgePS(gnrc,fp,lnk,pnt)
LinkStatus *gnrc; FILE *fp; LinkList *lnk; LinkPointList *pnt;
/* Prints out PS file for the edge, using millimeters as fundamental unit */ 
{
  LinkPointList *nxt;
  LinkCrossingList *crssng;
  double x,y,param,gamma;
  double tmp_x,tmp_y,delta_x,delta_y;

  if(pnt == NULL) return(0);
  if(pnt->next == NULL && lnk->closed == 0) return(0);
  nxt = pnt->next;
  if(nxt == NULL) /* Closed link, use first element */
  nxt = lnk->point.next;

  crssng = pnt->crossing.next;
  if(crssng == NULL) {  /* just draw line */
     fprintf(fp,"%.4lf %.4lf  %.4lf %.4lf vec\n",(double) (pnt->dcx)/xppmm,
                          (double) (pnt->dcy)/yppmm,
                          (double) (nxt->dcx)/xppmm,
                          (double) (nxt->dcy)/yppmm);
    }
  else {  /* Draw crossing gaps */
          /* Compute crossing gap vector */
     tmp_x = (double) (nxt->dcx - pnt->dcx)/xppmm;
     tmp_y = (double) (nxt->dcy - pnt->dcy)/yppmm;

     /* gamma = half fraction of total length devoted to each gap */
     gamma = 0.5*LINK_GAP/sqrt(tmp_x*tmp_x + tmp_y*tmp_y);
     delta_x = gamma * tmp_x; 
     delta_y = gamma * tmp_y; 

     x = (double) (pnt->dcx)/xppmm; 
     y = (double) (pnt->dcy)/yppmm;
     param = 0;

     while(crssng != NULL) {
        if(crssng->z < 0) {
           if(param < crssng->param - gamma) {
              fprintf(fp,"%.4lf %.4lf  %.4lf %.4lf vec\n",x,y,
                      (double) (crssng->dcx)/xppmm - delta_x,
                      (double) (crssng->dcy)/yppmm - delta_y);
             }
           if((param = crssng->param + gamma) > 1.0) {
              param = 1.0;
              x = (double) (nxt->dcx)/xppmm;
              y = (double) (nxt->dcy)/yppmm;
             }
           else {
              x = (double) (crssng->dcx)/xppmm  + delta_x;
              y = (double) (crssng->dcy)/yppmm  + delta_y;
             }
          }
        crssng = crssng->next;
       }
     /* Draw final piece */
     if(param < 1.0) {
        fprintf(fp,"%.4lf %.4lf  %.4lf %.4lf vec\n",x,y,
                            (double) (nxt->dcx)/xppmm,
                            (double) (nxt->dcy)/yppmm);
       }
    }
}

LinkPrintStrand3D(gnrc,fp,lnk)
LinkStatus *gnrc; FILE *fp; LinkList *lnk;
/* Prints out coordinate data for lnk, incorporating in */
/* the crossings as part of the data.  The result is a */
/* tubable strand.  The header is printed by the caller */
/* The format is the geometry group LINK format */
/* If a strand is not closed a warning message is printed */
{
  
  LinkPointList *pnt;
  LinkCrossingList *crssng;

  if(!lnk->closed) {
     fprintf(stderr,"Warning! Strand not closed! Printing data anyway...\n");
    }
  pnt = lnk->point.next;
  while(pnt != NULL) {
     fprintf(fp,"    %.4lf  %.4lf  %.4lf\n",pnt->x,pnt->y,pnt->z);
     crssng = pnt->crossing.next;
     while(crssng != NULL) {
        fprintf(fp,"    %.4lf  %.4lf  %.4lf\n",crssng->x,crssng->y,crssng->z);
        crssng = crssng->next;
       }
     pnt = pnt->next;
    }
  return(0);
}

LinkReadStrand(gnrc,fp,lnk)
LinkStatus *gnrc; FILE *fp; LinkList *lnk;
/* Reads strand data into lnk. */
/* Reads AFTER initial strand id to End */
/* returns 0 if successful */
{
  int i,done,ch;
  char strng[40];
  LinkPointList *pnt;
  double x,y,z;
 
  done = 0;
  while(!done) {
     if(fscanf(fp,"%s",strng) != 1) {
        LinkPrintMessage(gnrc,"Error reading link file.");
        return(-1);
       }
     if(strcmp(strng,"closed") == 0) {
        fscanf(fp,"%d",&(lnk->closed));
        continue;
       }

     if(strcmp(strng,"data") == 0) {
        fscanf(fp,"%d",&(lnk->num));
        pnt = &(lnk->point);
        for(i=0;i<lnk->num;++i) {
           if(fscanf(fp,"%lf %lf %lf",&x,&y,&z) != 3) {
              LinkPrintMessage(gnrc,"Error reading link file.");
              return(-1);
             }
           pnt->next = (LinkPointList *) malloc(sizeof(LinkPointList));
           if(pnt->next == NULL) {
              LinkPrintMessage(gnrc,"Out of memory reading link file.");
              return(-1);
             }
           pnt->next->previous = pnt;
           pnt = pnt->next;
           pnt->next = NULL;
           pnt->crossing.next = NULL;
           pnt->point_id = i;
           pnt->x = x; pnt->y = y; pnt->z = z; 
           LinkComputePointDeviceCoords(gnrc,pnt);
          }
        continue;
       }

     if(strng[0] == '#') { /* Read till end of line */
        ch = 'a';
        while(ch != '\n' && ch != '\r') {
           ch = fgetc(fp);
           if(ch == EOF) {
              LinkPrintMessage(gnrc,"Error reading link file comment.");
              return(-1);
             }
          }
       }

     if(strcmp(strng,"End") ==  0) {
       done = 1;
       continue;
      }
    }
  return(0);
}



