#ifndef VOID
#define VOID void
#endif

#define LINK_NO  0
#define LINK_YES 1

#define LINK_PAD   2
#define LINK_BORDER   1

#define LINK_NORMAL_VIDEO   0
#define LINK_REVERSE_VIDEO  1

#define LINK_X_FRACTION 0.5
#define LINK_Y_FRACTION 0.5
#define LINK_X_OFFSET   0.1
#define LINK_Y_OFFSET   0.1


#define LINK_POINT_X_SIZE 4   /* Size in pixels of control points */
#define LINK_POINT_Y_SIZE 4

#define LINK_ARROW_SIZE 3.0      /* Size of arrow in mm */


#define LINK_HIDE 0
#define LINK_SHOW 1

#define LINK_CURSOR      34       /* Cross hair cursor */

#define LINK_MAX_CHOICES 10  /* Maximum depth of choices */

#define LINK_X_HIT_RADIUS 6
#define LINK_Y_HIT_RADIUS 6

#define LINK_HASH_SPACE  15.0  /* Millimeters between labeled hash marks */
#define LINK_HASH_HEIGHT 3.0   /* Height of labeled hash marks */
#define LINK_GAP  4.0          /* Crossing gap in millimeters */

#define LINK_FEEDBACK_XFRACTION 0.5 /* fractional size of feedback rectangle */
#define LINK_FEEDBACK_YFRACTION 0.5 

#define LINK_PAUSE  50000  /* Pause time in microseconds */

#define LINK_LINE_WIDTH   2

/* Choices */

#define LINK_NO_CHOICE    -1
#define LINK_MOVE_POINT    0
#define LINK_ADD_POINT     1
#define LINK_DELETE_POINT  2
#define LINK_TRANSLATE_LINK     3
#define LINK_SCALE_LINK         4
#define LINK_ROTATE_LINK        5
#define LINK_SHIFT_VIEW     6
#define LINK_ZOOM_VIEW      7
#define LINK_FLIP_CROSSING  8
#define LINK_SELECT_LINK    9
#define LINK_HIDE_LINK      10
#define LINK_JOIN_SELECT_HEAD     11 
#define LINK_JOIN_SELECT_TAIL     12 
#define LINK_REVERSE_ARROWS       13
#define LINK_CLOSE_LINK           14
#define LINK_OPEN_LINK            15
#define LINK_DELETE_LINK          16

typedef struct link_crossing_list_struct LinkCrossingList;
typedef struct link_point_list_struct LinkPointList;

struct link_crossing_list_struct {
  double x,y,z;
  int dcx,dcy;
  double param;   /* crossing parameter */
  struct link_crossing_list_struct *next;
  struct link_point_list_struct *partner;   /* crossed segment */
  struct link_crossing_list_struct *crossing;  
       /* Reference to partner's corresponding crossing */
 };


struct link_point_list_struct {
  double x,y,z;
  int dcx,dcy;
  struct link_point_list_struct *next;
  struct link_point_list_struct *previous;
  LinkCrossingList crossing;  /* Linked list of crossings */
  int link_id;  /* Convenience id for identifying link when saving */
  int point_id; /* convenience id for i/o */
 };


struct link_list_struct {
   LinkPointList point;
   struct link_list_struct *next;
   int id,num,visible,closed;
 };

typedef struct link_list_struct LinkList;

typedef struct {    /* Run time data */
  Window TopWindow;         /* Top level window */
  Window TitleWindow;       /* Title bar */
  Window MessageWindow;     /* For messages */
  Window UrgentWindow;      /* For urgent messages */
  char title[40];
  char message[80];
  GC gc,reverse_gc;
  XFontStruct *fontstruct;
  int fth;

  LinkPointList origin;
  double xscale,yscale;
  int width,height;
  int axes,xruler,yruler,vertices,arrows;
  GC data_gc,reverse_data_gc,xor_gc;
  LinkList link,*current_link;
  int hash_space,hash_height;   /* values in pixels of hash spacing,height */
  int choice[LINK_MAX_CHOICES];
  XFontStruct *data_fontstruct;
  int data_fth;
  int num,color_ok; 
 } LinkStatus;

typedef struct {   /* initialization data */
  char title[40];
  char message[80];
  char font[40];
  double x,y,width,height;   /* Size and offset in millimeters */ 
  int border;
  Window root;
  int title_present,message_present,urgent_present;
            /* Are these windows present? */

  double xscale,yscale;
  int xruler,yruler;  /* Show rulers? */
  char data_font[40];
  double gray;   /* value between 0 and 1.0- background grey value */
 } LinkData;

extern LinkList *LinkFindLink();
extern LinkPointList *LinkFindPoint();
extern LinkPointList *LinkFindEdge();
extern LinkCrossingList *LinkFindCrossing();
extern LinkList *LinkCreateNewLink();
