#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/errno.h>

extern int errno;

char *todir = "/tmp/geomview";
char *toname = "Mathematica";

char timedout[] = "Couldn't start geomview\n";

static void
interrupt(int sig) { 
    write(2, timedout, sizeof(timedout));
    exit(1);
}

/*
 * Pipe fitting for linking Mathematica to geomview.
 * Starts geomview if not already running.
 */
main(int argc, char *argv[])
{
    int n, fd;
    char pipename[BUFSIZ];

    if(access(todir, W_OK) < 0) {
	mkdir(todir, 0777);
	chmod(todir, 0777);
    }
    sprintf(pipename, "%s/%s", todir, toname);
    if(access(pipename, 0) < 0) {
	mknod(pipename, S_IFIFO, 0);
	chmod(pipename, 0666);
    }
    fd = open(pipename, O_WRONLY|O_NONBLOCK);
    if(fd < 0 && errno == ENXIO) {
	signal(SIGALRM, interrupt);
	if(fork() == 0) {
	    setpgrp(0,0);
	    execlp("geomview", "geomview", "-c", pipename, NULL);
	    perror("Couldn't exec geomview");
	    kill(getppid(), SIGALRM);
	    exit(1);
	}
	alarm(15);
	fd = open(pipename, O_WRONLY);
	alarm(0);
    }
    if(fd < 0) {
	fprintf(stderr, "Can't open pipe to geomview: ");
	perror(pipename);
	exit(1);
    }
    while((n = read(0, pipename, sizeof(pipename))) > 0) {
	if(write(fd, pipename, n) < n) {
	    perror("Error writing to geomview");
	    exit(1);
	}
    }
    exit(0);
}
