#include "defines.h"
#include "cheyenne.h"
#define RADIUS .01

#define RED 123
#define GREEN (RED + 1)

static int color_dev = -1;

start_cheyenne(device,host,x,y,xx,yy)
char *device,*host;
float x,y,xx,yy;
{
    CY_Val foo;

    if (!device)
	device =
#ifdef SUN3
		"sunview";
#endif
#ifdef IRIS
		"mex";
#endif
#ifdef VAX
		"ascii";
#endif

    if (!host)
	host = "local";
    if (-1 == cy_open_device("Voronoi graphics",device,host))
		doing_ascii();
    cy_get_glo_var(CY_MAXDEPTH, &foo);
    if (foo.cont.ival <= 1)  color_dev = 0;
    if (-1 == cy_set_glo_var (CY_CANVAS_UNITS, (float) CY_NDC ))
	    cy_perror("cy_set_glo_var fails");
    if (-1 == cy_open_canvas ( "Voronoi graphics", x,y,xx,yy,CY_DEFDEPTH ) )
	    cy_perror("cy_open_canvas fails");
    if (-1 == cy_set_loc_var (CY_FILLING, TRUE ))
	    cy_perror("cy_set_loc_var fails");
}

doing_ascii()
{
    fprintf(stderr," cy_open_device fails, opening ASCII device\n");
    if (-1 == cy_open_device("Voronoi.cy","ascii","local")) 
	    exit(cy_perror("cannot open ascii device, cheyenne quits"));
}

colors(n,force)
int n, force;
{
        static float rl[] = {1.0, 0.0}, gl[] = {0.0, 0.0} , bl[] = {0.0, 1.0};
        static float rf[] = {0.0, 0.0, 1.0, 0.5}, gf[] = { 0.0, 1.0, 0.0, 0.5},
                bf[] = {1.0, 0.0, 0.0, 0.5} ;

	if (force)	{
		if (n == 4)
			cy_set_cmap_as_0_to_1( 2, 4, rf, gf, bf);
		if (n == 2)
			cy_set_cmap_as_0_to_1(RED, 2, rl, gl, bl);
		}

	else	{
		if (!color_dev)  {rl[0] = bl[1] = 0.0 ;}
		cy_set_cmap_as_0_to_1(RED, 2, rl, gl, bl);
		}
}


clear_screen()
{
	cy_set_canvas(0.0,0.0,1.0,1.0,0);
}

stop_cheyenne()
{
	cy_close_canvas(0);
	cy_close_device(0);
}
	
show_vertex(x,y,i)
float x,y;
int i;
{
        float xx[4], yy[4] ;
        xx[0] = xx[3] = x-RADIUS/2 ;
        xx[1] = xx[2] = x+RADIUS/2 ;
        yy[0] = yy[1] = y-RADIUS/2 ;
        yy[2] = yy[3] = y+RADIUS/2 ;

        if (-1 == cy_polygon (4, xx, yy, 1, i))
                cy_perror("cy_polygon fails");
}

show_line(x1,y1,x2,y2,style)
float x1,y1,x2,y2;
int style;
{
	static int old_style = CY_SOLID ;
	int color;

	style = style? CY_SOLID : CY_DASHED;
	color = style==CY_SOLID? RED : GREEN;
	if (!color_dev)
		if (style != old_style)	{
			old_style = style;
			cy_set_loc_var(CY_DRAW_STYLE, style);
			}
	if (-1 == cy_line(x1,y1,x2,y2,CY_SRC,color))
		cy_perror("cy_line fails");
}

show_polygon(n, x, y, color)
int n, color;
float *x, *y;
{
	if (-1 == cy_polygon ( n, x, y, CY_SRC, color))
		cy_perror("cy_polygon fails");
}

get_cursor(sl,sm,sr,xloca,yloca)
char *sl, *sm, *sr ;
float *xloca, *yloca;
{
        struct cy_event eventp;
	int rightb;
        int call = 1;
 
        cy_flush();
        do      {
                if (sl && (call%2))     /* let the button go back up */
                        fprintf(stderr,"left->%s, middle->%s, right->%s\n",
                                sl,sm,sr);
                eventp.type = -1;
                cy_get_event(&eventp, 10.0);
                rightb = (CY_KEYBD_KEYID(eventp.code)==CY_MOUSE_RIGHT) ;
                *xloca = eventp.x;
                *yloca = eventp.y ;
                call++;
                }
        while (!( (eventp.type == CY_MOUSE &&
				CY_MOUSE_STATE(eventp.code) == CY_MOUSE_UP)
		    || eventp.type == CY_KEYBD) );
	return rightb;
}
 
cy_flush()
{
        struct cy_event eventp;
 
        while(cy_get_event(&eventp, 0.0) != -1);
}
 
