#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk_imlib.h>

int main (int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *area;
    GtkWidget *pixmap;
    GdkImlibImage *image;
    GdkPixmap *data;
    GdkBitmap *mask;

    gtk_set_locale();
    gtk_init(&argc, &argv);
    gdk_imlib_init();

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    area = gtk_scrolled_window_new(NULL, NULL);

#ifdef WITHOUT_IMLIB
    gtk_widget_realize(window);
    data = gdk_pixmap_create_from_xpm(window->window, &mask, NULL, "hello.xpm");
#else
    image = gdk_imlib_load_image("hello.jpeg");
    if (!image) perror("gdk_imlib_load_image"), exit(1);

    gdk_imlib_render(image, image->rgb_width, image->rgb_height);
    data = gdk_imlib_move_image(image);
    mask = gdk_imlib_move_mask(image);
    pixmap = gtk_pixmap_new(data, mask);
#endif

    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(area), pixmap);
    gtk_container_add(GTK_CONTAINER(window), area);
    gtk_widget_set_usize(area, 400, 300);

    gtk_signal_connect(GTK_OBJECT(window), "destroy",
		       (GtkSignalFunc) gtk_main_quit, NULL);
    gtk_widget_show_all(window);

    gtk_main();

    gdk_imlib_free_pixmap(data);
    gdk_imlib_destroy_image(image);
    return 0;
}
