dnl Macros to help with configuring Python extensions via autoconf.
dnl  Copyright (C) 1998,  James Henstridge <james@daa.com.au>
dnl
dnl Distribute under the same rules as Autoconf itself.

dnl Check for location of python.
AC_DEFUN(PY_PROG_PYTHON,
[AC_PATH_PROG(PYTHON, python, /usr/local/python)])

dnl Check for python version
AC_DEFUN(PY_PYTHON_VERSION,
[AC_REQUIRE([PY_PROG_PYTHON])
AC_MSG_CHECKING(python version)
if test -z "$PYTHON_VERSION"; then
  AC_CACHE_VAL(py_cv_python_version,
  [changequote((_,_))
  py_cv_python_version=`$PYTHON -c 'import sys; print sys.version[:3]'`
  changequote([,])])
else
  py_cv_python_version="$PYTHON_VERSION"
fi
PYTHON_VERSION="$py_cv_python_version"
AC_MSG_RESULT($PYTHON_VERSION)
VERSION=$PYTHON_VERSION
AC_SUBST(VERSION)
AC_SUBST(PYTHON_VERSION)
])

dnl Check python installation prefix
AC_DEFUN(PY_PYTHON_PREFIX,
[AC_REQUIRE([PY_PROG_PYTHON])
AC_MSG_CHECKING(python installation prefix)
if test -z "$PYTHON_PREFIX"; then
  AC_CACHE_VAL(py_cv_python_prefix,
  [py_cv_python_prefix=`$PYTHON -c 'import sys; print sys.prefix'`])
else
  py_cv_python_prefix="$PYTHON_PREFIX"
fi
PYTHON_PREFIX="$py_cv_python_prefix"
AC_MSG_RESULT($PYTHON_PREFIX)
AC_SUBST(PYTHON_PREFIX)
prefix=$PYTHON_PREFIX
])

dnl Check python installation exec_prefix
AC_DEFUN(PY_PYTHON_EXEC_PREFIX,
[AC_REQUIRE([PY_PROG_PYTHON])
AC_MSG_CHECKING(python installation exec_prefix)
if test -z "$PYTHON_EXEC_PREFIX"; then
  AC_CACHE_VAL(py_cv_python_exec_prefix,
  [py_cv_python_exec_prefix=`$PYTHON -c 'import sys; print sys.exec_prefix'`])
else
  py_cv_python_exec_prefix="$PYTHON_EXEC_PREFIX"
fi
PYTHON_EXEC_PREFIX="$py_cv_python_exec_prefix"
AC_MSG_RESULT($PYTHON_EXEC_PREFIX)
AC_SUBST(PYTHON_EXEC_PREFIX)
exec_prefix=$PYTHON_EXEC_PREFIX
])

dnl get the relevant information from the python library Makefile
AC_DEFUN(PY_PYTHON_MAKE_VARS,
[AC_REQUIRE([PY_PYTHON_VERSION])
AC_REQUIRE([PY_PYTHON_PREFIX])
AC_MSG_CHECKING(definitions in Python library makefile)
AC_CACHE_VAL(py_cv_python_makefile_vars,
[py_makefile="${PYTHON_PREFIX}/lib/python${PYTHON_VERSION}/config/Makefile"
changequote((_,_))
eval `sed -n \
-e '/^CC=/ s/CC=[ 	]*\(.*\)/py_cv_python_makefile_CC='\''\1'\''/p' \
-e '/^OPT=/ s/OPT=[ 	]*\(.*\)/py_cv_python_makefile_OPT='\''\1'\''/p' \
-e '/^LDFLAGS=/ s/LDFLAGS=[ 	]*\(.*\)/py_cv_python_makefile_LDFLAGS='\''\1'\''/p' \
-e '/^DEFS=/ s/DEFS=[ 	]*\(.*\)/py_cv_python_makefile_DEFS='\''\1'\''/p' \
-e '/^LIBS=/ s/LIBS=[ 	]*\(.*\)/py_cv_python_makefile_LIBS='\''\1'\''/p' \
-e '/^LIBM=/ s/LIBM=[  	]*\(.*\)/py_cv_python_makefile_LIBM='\''\1'\''/p' \
-e '/^LIBC=/ s/LIBC=[ 	]*\(.*\)/py_cv_python_makefile_LIBC='\''\1'\''/p' \
-e '/^RANLIB=/ s/RANLIB=[ 	]*\(.*\)/py_cv_python_makefile_RANLIB='\''\1'\''/p' \
-e '/^MACHDEP=/ s/MACHDEP=[ 	]*\(.*\)/py_cv_python_makefile_MACHDEP='\''\1'\''/p' \
-e '/^SO=/ s/SO=[ 	]*\(.*\)/py_cv_python_makefile_SO='\''\1'\''/p' \
-e '/^LDSHARED=/ s/LDSHARED=[ 	]*\(.*\)/py_cv_python_makefile_LDSHARED='\''\1'\''/p' \
-e '/^CCSHARED=/ s/CCSHARED=[ 	]*\(.*\)/py_cv_python_makefile_CCSHARED='\''\1'\''/p' \
-e '/^LINKFORSHARED=/ s/LINKFORSHARED=[ 	]*\(.*\)/py_cv_python_makefile_LINKFORSHARED='\''\1'\''/p' \
-e '/^prefix=/ s/prefix=[ 	]*\(.*\)/py_cv_python_makefile_PREFIX='\''\1'\''/p' \
-e '/^exec_prefix=/ s/exec_prefix=[ 	]*\(.*\)/py_cv_python_makefile_EXEC_PREFIX='\''\1'\''/p' \
$py_makefile`
changequote([,])
py_cv_python_makefile_vars=found
])
CC="$py_cv_python_makefile_CC"
OPT="$py_cv_python_makefile_OPT"
LDFLAGS="$py_cv_python_makefile_LDFLAGS"
DEFS="$py_cv_python_makefile_DEFS"
LIBS="$py_cv_python_makefile_LIBS"
LIBM="$py_cv_python_makefile_LIBM"
LIBC="$py_cv_python_makefile_LIBC"
RANLIB="$py_cv_python_makefile_RANLIB"
MACHDEP="$py_cv_python_makefile_MACHDEP"
SO="$py_cv_python_makefile_SO"
LDSHARED="$py_cv_python_makefile_LDSHARED"
CCSHARED="$py_cv_python_makefile_CCSHARED"
LINKFORSHARED="$py_cv_python_makefile_LINKFORSHARED"
PREFIX="$py_cv_python_makefile_PREFIX"
EXEC_PREFIX="$py_cv_python_makefile_EXEC_PREFIX"
echo "$DEFS" >> confdefs.h
AC_SUBST(CC)
AC_SUBST(OPT)
AC_SUBST(LDFLAGS)
AC_SUBST(DEFS)
AC_SUBST(LIBS)
AC_SUBST(LIBM)
AC_SUBST(LIBC)
AC_SUBST(RANLIB)
AC_SUBST(MACHDEP)
AC_SUBST(SO)
AC_SUBST(LDSHARED)
AC_SUBST(CCSHARED)
AC_SUBST(LINKFORSHARED)
AC_SUBST(PREFIX)
AC_SUBST(EXEC_PREFIX)
AC_MSG_RESULT(done)
])

dnl make FILE from FILE.pre.in using config.status and makesetup
AC_DEFUN(PY_OUTPUT,
[AC_OUTPUT($1.pre $2 $3,
dnl here is a hack so that I can get shell variable expansion to occur
[EOF
cat >> $CONFIG_STATUS <<EOF
echo creating $1
MAKESETUP="${PYTHON_PREFIX}/lib/python${PYTHON_VERSION}/config/makesetup"
CONFIGCIN="${PYTHON_PREFIX}/lib/python${PYTHON_VERSION}/config/config.c.in"
\$MAKESETUP -m $1.pre -c \$CONFIGCIN $2
])])

